# Copyright 2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="libraries"
PYTHON_COMPAT=( python3_{8..13} )

inherit trinity-base-2 python-single-r1

DESCRIPTION="Trinity bindings for Python - Development files and scripts"
HOMEPAGE="https://trinitydesktop.org/"
LICENSE="GPL-2"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="examples"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~trinity-base/tdelibs-${PV}
	~dev-python/sip4-tqt-${PV}
	~x11-libs/tqscintilla-${PV}
	~dev-tqt/tqtinterface-${PV}
	~dev-python/pytqt-${PV}
"
RDEPEND="${DEPEND}"

TQBASE="/usr/tqt3"
BUILD_DIR="${S}"

src_prepare() {
	eapply_user
}

src_configure() {
	local myconf
	myconf=(
	-k "${TDEDIR}"
	-L "${TDEDIR}/$(get_libdir)"
	-v "${TQBASE}/sip/tde"
	)
	"${EPYTHON}" configure.py "${myconf[@]}" || die
}

src_compile() {
	emake
}

src_install() {
	emake install DESTDIR="${D}"
	if use examples ; then
		insinto "${TDEDIR}/share/pytde/examples"
		doins examples/*
		local EDIR
		for EDIR in uimodules pytde-sampler pytde-sampler/basic_widgets pytde-sampler/dialogs \
					pytde-sampler/icon_handling pytde-sampler/misc pytde-sampler/qt_widgets pytde-sampler/xwin
		do
			insinto "${TDEDIR}/share/pytde/examples/${EDIR}"
			doins "examples/${EDIR}"/*
		done
	fi
}
