/* ============================================================
 * File   : plugin.h
 * Authors: KIPI team developers (see AUTHORS files for details)
 *	    
 * Date   : 2004-02
 * Description :
 *
 * Copyright 2004 by the KIPI team
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */

#ifndef KIPI_PLUGIN_H
#define KIPI_PLUGIN_H

// TQt includes.

#include <tqobject.h>

// KDE includes.

#include <tdeaction.h>

// Lib KIPI includes.

#include "libkipi/interface.h"

#include "libkipi/libkipi_export.h"

class TDEInstance;

/** @namespace KIPI */
namespace KIPI
{
    enum Category 
       {
       IMAGESPLUGIN = 0,
       EFFECTSPLUGIN,
       TOOLSPLUGIN,
       IMPORTPLUGIN,
       EXPORTPLUGIN,
       BATCHPLUGIN,
       COLLECTIONSPLUGIN
       };

    class LIBKIPI_EXPORT Plugin : public TQObject
    {
    public:
        Plugin( TDEInstance* instance, TQObject *parent, const char* name);
        virtual ~Plugin();

        virtual void setup( TQWidget* widget ) = 0;
        TDEActionPtrList actions( TQWidget* parent = 0 );
        TDEActionCollection* actionCollection( TQWidget* parent = 0 );
        virtual Category category( TDEAction* action ) const = 0;

    protected:
        void addAction( TDEAction* action );

    private:
        struct Private;
        Private* d;
    };
}

#endif  // KIPI_PLUGIN_H 
