/*  This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kchmpart_h__
#define __kchmpart_h__

#include <tdeparts/factory.h>
#include <tdeparts/part.h>
#include <tdeparts/browserextension.h>
#include <tdehtml_part.h>
#include <tdeio/job.h>
#include <tdeio/jobclasses.h>
#include <kdevhtmlpart.h>

#include <tqcstring.h>

class TDEInstance;
class TDEAboutData;

class KChmPartFactory: public KParts::Factory
{
   TQ_OBJECT
  
   public:
      KChmPartFactory( TQObject *parent = 0, const char *name = 0 );
      virtual ~KChmPartFactory();

      virtual KParts::Part* createPartObject(
		  TQWidget *parentWidget, const char *widgetName,
          TQObject *parent, const char *name,
		  const char *classname, const TQStringList &args );

      static TDEInstance *instance();

   private:
      static TDEInstance *s_instance;
      static TDEAboutData *s_about;

};


class KChmPart : public KDevHTMLPart
{
   TQ_OBJECT
  
   public:
      KChmPart( TQWidget *, const char * = 0 );
      KParts::BrowserExtension * extension() { return m_extension; }

   public slots:
      virtual bool openURL( const KURL & );
/*
   protected slots:
      void readData(TDEIO::Job * , const TQByteArray & data);
      void jobDone( TDEIO::Job *);
*/
   protected:
      //virtual bool openFile();
      TDEInstance *m_instance;
      KParts::BrowserExtension *m_extension;
      TDEIO::TransferJob *m_job;
      TQCString m_htmlData;

   protected slots:
      virtual void slotDuplicate();
      virtual void slotOpenInNewWindow(const KURL &url);

};

#endif // __kchmpart_h__

