/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#ifndef DIALOG_UTILS_H
#define DIALOG_UTILS_H

#include <tqstring.h>

class TQGroupBox;
class TQGridLayout;
class TQLabel;
class TQLineEdit;
class UMLWidget;

/**
 * Dialog utilities.
 * @author Oliver Kellogg
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.trinitydesktop.org
 */
namespace Dialog_Utils {

/**
 * Create a labeled text lineedit widget.
 *
 * @param containingBox         The containing TQGroupBox.
 * @param layout                The TQGridLayout to use.
 * @param row                   The row number within the TQGridLayout.
 * @param label                 The TQLabel object allocated (return value)
 * @param labelText             The label text.
 * @param editField             The TQLineEdit object allocated (return value)
 * @param editFieldText         Initialization text in the editField (optional.)
 * @return a pointer to the TQLineEdit so you can setFocus() if necessary
 */
TQLineEdit* makeLabeledEditField(TQGroupBox *containingBox, TQGridLayout *layout, int row,
                                TQLabel * &label, const TQString& labelText,
                                TQLineEdit * &editField,
                                const TQString& editFieldText = TQString());

/**
 * Helper function for requesting a name for an UMLWidget using a dialog.
 *
 * @param targetWidget          By-reference pointer to the widget to request the name for.
 *                              The widget may be deallocated, and the pointer returned
 *                              set to NULL, if the user presses Cancel in the dialog.
 * @param dialogTitle           Title of the dialog.
 * @param dialogPrompt          Prompt of the dialog.
 * @param defaultName           Default value of the name field.
 */
void askNameForWidget(UMLWidget * &targetWidget, const TQString& dialogTitle,
                      const TQString& dialogPrompt, const TQString& defaultName);

}

#endif

