 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (C) 2004-2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef GROUPDAVGLOBALS_H
#define GROUPDAVGLOBALS_H

#include <groupwareuploadjob.h>
#include <folderlister.h>
#include <kurl.h>
#include <tqdom.h>

namespace KPIM {
class GroupwareDataAdaptor;
class GroupwareUploadItem;
}
namespace TDEIO {
class TransferJob;
class Job;
}
namespace TDEABC {
class AddressBookAdaptor;
}
namespace KCal {
class CalendarAdaptor;
}

class GroupDavGlobals
{
  public:
    GroupDavGlobals() {}
    static TQString extractFingerprint( TDEIO::Job *job, const TQString &/*jobData*/ );
    static KPIM::FolderLister::ContentType getContentType( const TQDomElement &prop );
    static KPIM::FolderLister::ContentType getContentType( const TQDomNode &folderNode );
    static bool getFolderHasSubs( const TQDomNode &folderNode );


    static TDEIO::Job *createListFoldersJob( const KURL &url );
    static TDEIO::TransferJob *createListItemsJob( const KURL &url );
    static TDEIO::TransferJob *createDownloadJob( KPIM::GroupwareDataAdaptor *adaptor,
                       const KURL &url, KPIM::FolderLister::ContentType ctype );
    static TDEIO::Job *createRemoveJob( KPIM::GroupwareDataAdaptor *adaptor, const KURL &uploadurl,
                          KPIM::GroupwareUploadItem *deletedItems );


    static bool interpretListItemsJob( KPIM::GroupwareDataAdaptor *adaptor,
                                       TDEIO::Job *job );
    static bool interpretCalendarDownloadItemsJob( KCal::CalendarAdaptor *adaptor,
                                        TDEIO::Job *job, const TQString &jobData );
    static bool interpretAddressBookDownloadItemsJob( TDEABC::AddressBookAdaptor *adaptor,
                                        TDEIO::Job *job, const TQString &jobData );

};

#endif
