#ifndef KSIRCSERVER_H
#define KSIRCSERVER_H

#include <tqptrlist.h>
#include <tqstring.h>

class KSircServer
{

public:
    KSircServer( const TQString &server,
		 const TQString &port,
		 const TQString &script = TQString(),
		 const TQString &password  = TQString(),
		 bool ssl = false ) :
        m_server(server), m_port(port), m_script(script),
	m_password(password), m_ssl(ssl) {}

  const TQString server() const     { return m_server; }
  const TQString port() const      { return m_port; }
  const TQString script() const     { return m_script; }
  const TQString password() const   { return m_password; }
  bool    usessl() const     { return m_ssl; }

private:
  const TQString     m_server;
  const TQString     m_port;
  const TQString     m_script;
  const TQString     m_password;
  const bool        m_ssl;

};

#endif
