/***************************************************************************

                       edit "additional" properties

    -----------------------------------------------------------------------

    begin          : Thu Nov 25 17:29:44 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef AuxInfoEntryPage_included
#define AuxInfoEntryPage_included

#include "AuxInfoEntryPageForm.h"

class EntryDlg;

class AuxInfoEntryPage : public AuxInfoEntryPageForm
{
  TQ_OBJECT
  

public:
  AuxInfoEntryPage
  (
    EntryDlg   *dlgbook,
    bool        multi_sel,
    TQString     syno,
    TQString     anto,
    TQString     example,
    TQString     remark,
    TQString     para,
    TQWidget    *parent = 0,
    const char *name = 0
  );

  void setData(bool multi_sel, TQString syno, TQString anto, TQString example, TQString remark, TQString  para);

  TQString getSynonym ();
  TQString getAntonym ();
  TQString getExample ();
  TQString getRemark  ();
  TQString getParaphrase();

  bool isModified();
  void setModified(bool mod = true);
  void setEnabled(int enable_type);

signals:
  void sigModified();

protected:
  void normalize(TQString &str);

protected slots:
  void slotAntonymSelected();
  void slotSynonymSelected();
  void slotExampSelected();
  void slotRemarkSelected();
  void slotParaSelected();

protected:
  TQString       synonym;
  TQString       antonym;
  TQString       example;
  TQString       remark;
  TQString       paraphrase;
  bool          modified;
  EntryDlg     *dlgbook;
};

#endif // AuxInfoEntryPage_included
