#include "xparthost_kpart.h"
#include "kbrowsersignals.h"
#include "xpart_stub.h"

#include <dcopclient.h>
#include <tdeapplication.h>

#include <assert.h>

#include <qxembed.h>

#include <tqdom.h>
#include <tdeaction.h>

#include <kdebug.h>

XPartHost_KPart::XPartHost_KPart( TQWidget *parentWidget, const char *widgetName,
	                          TQObject *parent, const char *name )
    : KParts::ReadOnlyPart( parent, name ),
      XPartHost("parthost")
{
    m_stub = 0;
    be = 0;
    embed = new QXEmbed(parentWidget, widgetName);
    setWidget(embed);
}

XPartHost_KPart::~XPartHost_KPart()
{
    delete m_stub;
}

DCOPRef XPartHost_KPart::part()
{
    return m_part;
}

DCOPRef XPartHost_KPart::registerXPart( const DCOPRef &part )
{
    m_part = part;

    assert( m_stub == 0 );

    m_stub = new XPart_stub( part.app(), part.object() );
    m_stub->show();

    kdDebug() << "embedding window " << m_stub->windowId() << endl;
    embed->embed( static_cast<WId>( m_stub->windowId() ) );

    embed->show();
     DCOPRef ref = m_stub->queryExtension("browserextension");
     if( !ref.isNull() ) {
	 tqDebug(" found browser extension ");
	 be = new KBrowserSignals( this, ref );
     }
    return DCOPRef( kapp->dcopClient()->appId(), objId() );
}


void XPartHost_KPart::createActions( const TQCString &xmlActions )
{
    tqDebug("--> createActions");
    // creates a set of actions and adds them to the actionCollection
    TQDomDocument d;
    d.setContent( xmlActions );

    TQDomElement docElem = d.documentElement();

    kdDebug() << "docElement is " << docElem.tagName() << endl;

    TQDomNode n = docElem.firstChild();
    while( !n.isNull() ) {
        TQDomElement e = n.toElement();
        if( !e.isNull() ) {
            if ( e.tagName() == "Action") {
                TQString name = e.attribute("name");
                TQString type = e.attribute("type");

                if(type.isEmpty())
                    new TDEAction( name, 0, this, TQ_SLOT( actionActivated() ), actionCollection(), name.latin1() );
                else if( type == "toggle" )
                    new TDEToggleAction( name, 0, this, TQ_SLOT( actionActivated() ), actionCollection(), name.latin1() );
                kdDebug() << "action=" << name << "  type=" << type << endl;
            } else if ( e.tagName() == "XMLFile" ) {
                TQString location = e.attribute("location");
                setXMLFile(location);
            }
        }
        n = n.nextSibling();
    }
    emit actionsInitialized();
}


void XPartHost_KPart::setWindowCaption( const TQString &caption )
{
    emit KParts::ReadOnlyPart::setWindowCaption( caption );
}

void XPartHost_KPart::setStatusBarText( const TQString &text )
{
    emit KParts::ReadOnlyPart::setStatusBarText( text );
}

void XPartHost_KPart::started()
{
    emit KParts::ReadOnlyPart::started( 0 );
}

void XPartHost_KPart::completed()
{
    emit KParts::ReadOnlyPart::completed();
}

void XPartHost_KPart::canceled( const TQString &errMsg )
{
    emit KParts::ReadOnlyPart::canceled( errMsg );
}

bool XPartHost_KPart::openURL( const KURL &url )
{
    tqDebug("XPartHost_KPart::openUrl()");
    return m_stub->openURL( url.url().latin1() );
}

bool XPartHost_KPart::closeURL()
{
    return m_stub->closeURL();
}


void XPartHost_KPart::actionActivated()
{
    const TQObject *o = sender();

    if( !o->inherits("TDEAction") ) return;

    const TDEAction *action = static_cast<const TDEAction *>(o);
    TQString name = action->text();
    int state = 0;

    if(action->inherits("TDEToggleAction")) {
        const TDEToggleAction *t = static_cast<const TDEToggleAction *>(action);
        state = t->isChecked();
    }

    m_stub->activateAction(name, state);
}

#include "xparthost_kpart.moc"
