//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQFont;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQWidget;

/**

 The TDEFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the TDEFontChooser widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method TDEFontDialog.getFont(),
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.
 Example:
 <pre>
      TQFont myFont;
      int result = TDEFontDialog.getFont( myFont );
      if ( result == TDEFontDialog.Accepted )
            ...
 </pre>
 \image html tdefontdialog.png "KDE Font Dialog"
 See {@link TDEFontDialogSignals} for signals emitted by TDEFontDialog
		@author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

		@version $Id$

		@short A font selection dialog.

*/
public class TDEFontDialog extends KDialogBase  {
	protected TDEFontDialog(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a font selection dialog.
			@param parent The parent widget of the dialog, if any.
			@param name The name of the dialog.
			@param modal Specifies whether the dialog is modal or not.
			@param onlyFixed only display fonts which have fixed-width
		        character sizes.
			@param fontlist a list of fonts to display, in XLFD format.  If
		        no list is formatted, the internal KDE font list is used.
		        If that has not been created, X is queried, and all fonts
		        available on the system are displayed.
			@param makeFrame Draws a frame with titles around the contents.
			@param diff Display the difference version dialog. See getFontDiff().
			@param sizeIsRelativeState If not zero the widget will show a
		        checkbox where the user may choose whether the font size
		        is to be interpreted as relative size.
		        Initial state of this checkbox will be set according to
		        sizeIsRelativeState, user choice may be retrieved by
		        calling sizeIsRelative().
			   		@short    Constructs a font selection dialog.
	*/
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff, int sizeIsRelativeState) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed,modal,fontlist,makeFrame,diff,sizeIsRelativeState);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff, int sizeIsRelativeState);
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed,modal,fontlist,makeFrame,diff);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff);
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed,modal,fontlist,makeFrame);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame);
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed,modal,fontlist);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist);
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed,modal);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed, boolean modal);
	public TDEFontDialog(TQWidget parent, String name, boolean onlyFixed) {
		super((Class) null);
		newTDEFontDialog(parent,name,onlyFixed);
	}
	private native void newTDEFontDialog(TQWidget parent, String name, boolean onlyFixed);
	public TDEFontDialog(TQWidget parent, String name) {
		super((Class) null);
		newTDEFontDialog(parent,name);
	}
	private native void newTDEFontDialog(TQWidget parent, String name);
	public TDEFontDialog(TQWidget parent) {
		super((Class) null);
		newTDEFontDialog(parent);
	}
	private native void newTDEFontDialog(TQWidget parent);
	public TDEFontDialog() {
		super((Class) null);
		newTDEFontDialog();
	}
	private native void newTDEFontDialog();
	/**
		 Sets the currently selected font in the dialog.
			@param font The font to select.
			@param onlyFixed readjust the font list to display only fixed
		        width fonts if true, or vice-versa
		   		@short    Sets the currently selected font in the dialog.
	*/
	public native void setFont(TQFont font, boolean onlyFixed);
	public native void setFont(TQFont font);
	/**
				@return The currently selected font in the dialog.

		@short
	*/
	public native TQFont font();
	/**
		 Sets the state of the checkbox indicating whether the font size
		 is to be interpreted as relative size.
		 NOTE: If parameter sizeIsRelative was not set in the constructor
		       of the dialog this setting will be ignored.
		   		@short    Sets the state of the checkbox indicating whether the font size  is to be interpreted as relative size.
	*/
	public native void setSizeIsRelative(int relative);
	/**
				@return Whether the font size is to be interpreted as relative size
         (default: false)

		@short
	*/
	public native int sizeIsRelative();
	/**
		 Creates a modal font dialog, lets the user choose a font,
		 and returns when the dialog is closed.
			@param theFont a reference to the font to write the chosen font
		        into.
			@param onlyFixed if true, only select from fixed-width fonts.
			@param parent Parent widget of the dialog. Specifying a widget different
		        from 0 (Null) improves centering (looks better).
			@param makeFrame Draws a frame with titles around the contents.
			@param sizeIsRelativeState If not zero the widget will show a
		        checkbox where the user may choose whether the font size
		        is to be interpreted as relative size.
		        Initial state of this checkbox will be set according to
		        sizeIsRelativeState and user choice will be returned
		        therein.
				@return TQDialog.result().

		@short    Creates a modal font dialog, lets the user choose a font,  and returns when the dialog is closed.
	*/
	public static native int getFont(TQFont theFont, boolean onlyFixed, TQWidget parent, boolean makeFrame, int sizeIsRelativeState);
	public static native int getFont(TQFont theFont, boolean onlyFixed, TQWidget parent, boolean makeFrame);
	public static native int getFont(TQFont theFont, boolean onlyFixed, TQWidget parent);
	public static native int getFont(TQFont theFont, boolean onlyFixed);
	public static native int getFont(TQFont theFont);
	/**
		 Creates a modal font difference dialog, lets the user choose a selection
		 of changes that should be made to a set of fonts, and returns when the
		 dialog is closed. Useful for choosing slight adjustments to the font set
		 when the user would otherwise have to manually edit a number of fonts.
			@param theFont a reference to the font to write the chosen font
		        into.
			@param diffFlags a reference to the int into which the chosen
		        difference selection bitmask should be written.
		        Check the returned bitmask like:
		        <pre>
		        if ( diffFlags & TDEFontChooser.FontDiffFamily )
		            [...]
		        if ( diffFlags & TDEFontChooser.FontDiffStyle )
		            [...]
		        if ( diffFlags & TDEFontChooser.FontDiffSize )
		            [...]
		        </pre>
			@param onlyFixed if true, only select from fixed-width fonts.
			@param parent Parent widget of the dialog. Specifying a widget different
		        from 0 (Null) improves centering (looks better).
			@param makeFrame Draws a frame with titles around the contents.
			@param sizeIsRelativeState If not zero the widget will show a
		        checkbox where the user may choose whether the font size
		        is to be interpreted as relative size.
		        Initial state of this checkbox will be set according to
		        sizeIsRelativeState and user choice will be returned
		        therein.
				@return TQDialog.result().

		@short    Creates a modal font difference dialog, lets the user choose a selection  of changes that should be made to a set of fonts, and returns when the  dialog is closed.
	*/
	public static native int getFontDiff(TQFont theFont, int[] diffFlags, boolean onlyFixed, TQWidget parent, boolean makeFrame, int sizeIsRelativeState);
	public static native int getFontDiff(TQFont theFont, int[] diffFlags, boolean onlyFixed, TQWidget parent, boolean makeFrame);
	public static native int getFontDiff(TQFont theFont, int[] diffFlags, boolean onlyFixed, TQWidget parent);
	public static native int getFontDiff(TQFont theFont, int[] diffFlags, boolean onlyFixed);
	public static native int getFontDiff(TQFont theFont, int[] diffFlags);
	/**
		 When you are not only interested in the font selected, but also
		 in the example string typed in, you can call this method.
			@param theFont a reference to the font to write the chosen font
		        into.
			@param theString a reference to the example text that was typed.
			@param onlyFixed if true, only select from fixed-width fonts.
			@param parent Parent widget of the dialog. Specifying a widget different
		        from 0 (Null) improves centering (looks better).
			@param makeFrame Draws a frame with titles around the contents.
			@param sizeIsRelativeState If not zero the widget will show a
		        checkbox where the user may choose whether the font size
		        is to be interpreted as relative size.
		        Initial state of this checkbox will be set according to
		        sizeIsRelativeState and user choice will be returned
		        therein.
				@return The result of the dialog.

		@short    When you are not only interested in the font selected, but also  in the example string typed in, you can call this method.
	*/
	public static native int getFontAndText(TQFont theFont, StringBuffer theString, boolean onlyFixed, TQWidget parent, boolean makeFrame, int sizeIsRelativeState);
	public static native int getFontAndText(TQFont theFont, StringBuffer theString, boolean onlyFixed, TQWidget parent, boolean makeFrame);
	public static native int getFontAndText(TQFont theFont, StringBuffer theString, boolean onlyFixed, TQWidget parent);
	public static native int getFontAndText(TQFont theFont, StringBuffer theString, boolean onlyFixed);
	public static native int getFontAndText(TQFont theFont, StringBuffer theString);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
