require 'Qt'
require 'lcdrange.rb'
require 'cannon.rb'

class GameBoard < TQt::Widget

    slots 'fire()', 'hit()', 'missed()', 'newGame()'

    def initialize()
        super
        quit = TQt::PushButton.new('&Quit', self, 'quit')
        quit.setFont(TQt::Font.new('Times', 18, TQt::Font::Bold))
    
        connect(quit, TQ_SIGNAL('clicked()'), $qApp, TQ_SLOT('quit()'))
    
        angle = LCDRange.new( 'ANGLE', self, 'angle' )
        angle.setRange( 5, 70 )
        
        force  = LCDRange.new( 'FORCE', self, 'force' )
        force.setRange( 10, 50 )
        
        @cannonField = CannonField.new( self, 'cannonField' )

        connect( angle, TQ_SIGNAL('valueChanged(int)'),
                @cannonField, TQ_SLOT('setAngle(int)') )
        connect( @cannonField, TQ_SIGNAL('angleChanged(int)'),
                angle, TQ_SLOT('setValue(int)') )

        connect( force, TQ_SIGNAL('valueChanged(int)'),
                @cannonField, TQ_SLOT('setForce(int)') )
        connect( @cannonField, TQ_SIGNAL('forceChanged(int)'),
                force, TQ_SLOT('setValue(int)') )
        
        connect( @cannonField, TQ_SIGNAL('hit()'),
                    self, TQ_SLOT('hit()') )
        connect( @cannonField, TQ_SIGNAL('missed()'),
                    self, TQ_SLOT('missed()') )
                
        shoot = TQt::PushButton.new( '&Shoot', self, 'shoot' )
        shoot.setFont( TQt::Font.new( 'Times', 18, TQt::Font::Bold ) )

        connect( shoot, TQ_SIGNAL('clicked()'), TQ_SLOT('fire()') )
        connect( @cannonField, TQ_SIGNAL('canShoot(bool)'),
                    shoot, TQ_SLOT('setEnabled(bool)') )
                                
        restart = TQt::PushButton.new( '&New Game', self, 'newgame' )
        restart.setFont( TQt::Font.new( 'Times', 18, TQt::Font::Bold ) )

        connect( restart, TQ_SIGNAL('clicked()'), self, TQ_SLOT('newGame()') )

        @hits = TQt::LCDNumber.new( 2, self, 'hits' )
        @shotsLeft = TQt::LCDNumber.new( 2, self, 'shotsleft' )
        hitsL = TQt::Label.new( 'HITS', self, 'hitsLabel' )
        shotsLeftL = TQt::Label.new( 'SHOTS LEFT', self, 'shotsleftLabel' )
                
        grid = TQt::GridLayout.new( self, 2, 2, 10 )
        grid.addWidget( quit, 0, 0 )
        grid.addWidget( @cannonField, 1, 1 )
        grid.setColStretch( 1, 10 )

        leftBox = TQt::VBoxLayout.new()
        grid.addLayout( leftBox, 1, 0 )
        leftBox.addWidget( angle )
        leftBox.addWidget( force )
    
        topBox = TQt::HBoxLayout.new()
        grid.addLayout( topBox, 0, 1 )
        topBox.addWidget( shoot )
        topBox.addWidget( @hits )
        topBox.addWidget( hitsL )
        topBox.addWidget( @shotsLeft )
        topBox.addWidget( shotsLeftL )
        topBox.addStretch( 1 )
        topBox.addWidget( restart )
    
        angle.setValue( 60 )
        force.setValue( 25 )
        angle.setFocus()
        
        newGame()
    end
    
    def fire()
        if @cannonField.gameOver() || @cannonField.isShooting()
            return
        end
        @shotsLeft.display( @shotsLeft.intValue() - 1 )
        @cannonField.shoot()
    end

    def hit()
        @hits.display( @hits.intValue() + 1 )
        if @shotsLeft.intValue() == 0
            @cannonField.setGameOver()
        else
            @cannonField.newTarget()
        end
    end

    def missed()
        if @shotsLeft.intValue() == 0
            @cannonField.setGameOver()
        end
    end

    def newGame()
        @shotsLeft.display( 15.0 )
        @hits.display( 0 )
        @cannonField.restartGame()
        @cannonField.newTarget()
    end
end
