/***************************************************************************
                          fileoperation.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// TDE includes
#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdeio/netaccess.h>
#include <tdeio/job.h>

// TQt includes
#include <tqeventloop.h>

#include <tqfileinfo.h>

// OS includes
#include <stdio.h>
#include <unistd.h>

// Own includes
#include "fileoperation.h"
#include "ProgressDialog.h"
#include "batchrenamer.h"

using namespace TDEIO;

FileOperation::FileOperation()
{
    canceled = false;
}

FileOperation::~FileOperation() { }

bool FileOperation::start( const KURL & src, const KURL & dest, int mode, bool overwrite )
{
    locked = true;
    result = 0;

    if( src == dest && !overwrite ) {
        m_error = i18n( "File %1 exists already!").arg( dest.prettyURL() );
        return false;
    }
    
    Job* job = 0;
    switch( mode ) {
        case RENAME:
        case MOVE:
        default:
            job = file_move( src, dest, -1, overwrite, false, false ); 
            break;
        case COPY:
            job = file_copy( src, dest, -1, overwrite, false, false ); 
            break;
        case LINK:
            // Does only work if both files are on the same host
            if( src.protocol() == dest.protocol() && src.host() == dest.host() )
            {
                job = symlink( src.path(), dest, overwrite, false );
            }
            else
            {
                m_error = i18n("Can't create symlinks on different hosts for file %1.").arg( src.prettyURL() );
                result = true;
                return !result;
            }
            break;
    };

    if( !job )
        return false;
        
    job->setAutoErrorHandlingEnabled( false, 0 );
    connect( job, TQ_SIGNAL( result (TDEIO::Job *) ),
           this, TQ_SLOT( slotResult (TDEIO::Job *) ) );

    kapp->eventLoop()->enterLoop();
    return !result;
}

bool FileOperation::fcopy( const TQString & src, const TQString & dest )
{
    return start( KURL( src ), KURL( dest ), TDEIO::CopyJob::Copy, false );
}

TQString FileOperation::getName( const TQString & file )
{
    TQFileInfo info( file );
    return info.fileName();
}

void FileOperation::slotResult( TDEIO::Job * job )
{
    result = job->error();
    if( result )
        m_error = job->errorString();

    kapp->eventLoop()->exitLoop();
}

#include "fileoperation.moc"
