/***************************************************************************
                          databasebrowser.h  -  description
                             -------------------
    begin                : Mit Mai 15 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASEBROWSER_H
#define DATABASEBROWSER_H

#include "dsmainwindow.h"

class TDEAction;
class KEdFind;
class KMenuBar;
class TDEToolBar;
class KPushButton;
class TDEPopupMenu;
class MyDataTable;
/** A database browser widget. Allows small changes to SQL tables
  * and is mostly used for having a quick look on the tables.
  */
class DatabaseBrowser : public DSMainWindow{
    TQ_OBJECT
  
    public:
        DatabaseBrowser( TQString _database, TQWidget *parent=0, const char *name=0);
        ~DatabaseBrowser();

    private:
        void setupActions();

    private slots:
        void setupSql();

        void cut();
        void copy();
        void paste();

        void find();
        void findNext();

        void import();

    protected:
        TQString database;
        MyDataTable* table;

        TDEAction* undoAct;
        TDEAction* deleteAct;
        TDEAction* newAct;

        KEdFind* findDlg;

        TQString m_find;
        bool m_direction;
        bool m_case;
};

#endif
