/*
 *
 *  Adapter config dialog for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef ADAPTERCONFIG_H_
#define ADAPTERCONFIG_H_

#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqtabwidget.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqcombobox.h>
#include <tqobject.h>
#include <tqslider.h>

#include <adapterImpl.h>

#include "adapterdialog.h"
#include "application.h"

using namespace TDEBluetooth;

class AdapterConfig: public TQObject
{
    TQ_OBJECT

public:
    AdapterConfig(ObjectManagerImpl *mgr, AdapterImpl *adapter);
    ~AdapterConfig();

    AdapterDialog *dialog() const
    {
        return adapterDialog;
    }
    ;
    TQString getName()
    {
        return name;
    }
    ;

public slots:
    // from adapter
    void slotAdapterNameChanged(const TQString&, const TQString&);
    void slotPowerOnChanged(const TQString&, bool);
    void slotDiscoverableChanged(const TQString&, bool);
    void slotDiscoverableTimeoutChanged(const TQString&, TQ_UINT32 timeout);
    // from dialog
    void slotChangeName(const TQString& name);
    void slotSetMode(int);
    void slotSetClass(const TQString& mime);
    void slotChangeTimeout(int timeout);

private:
    AdapterDialog *adapterDialog;
    AdapterImpl *adapter;
    ObjectManagerImpl *manager;
    TQString name;
    void addAdapterDialogInfo();
};

#endif // ADAPTERCONFIG_H_
