/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _LOADING_DIALOG_H_
#define _LOADING_DIALOG_H_

#include <tqwidget.h>
#include <tqpushbutton.h>
#include <tqlabel.h>

#include <kprogress.h>
#include <kiconloader.h>

#include "view.h"
#include "logListItem.h"

/**
 * To use this class, simply call set the Loading Log, and update with setProcess
 * To manage group of Logs, use setCount() and setCurrent() methods
 *
 * TODO Make the processEvents() method here (move from KSystemLog class
 * (and also remove signal/slot dedicated for this operation))
 *
 * TODO Try to have the Cancel button functional (for the moment, it only hide the Loading Dialog)
 */
class LoadingDialog : public KProgressDialog {

	TQ_OBJECT
  
	
	public:
		LoadingDialog(TQWidget* parent=0, const char* name=0, bool modal=false);
		
		~LoadingDialog();
		
		void setLoadingLog(const TQString& text);
		
		//Methods managing the position in the tab loading
		int getTabCount();
		void setTabCount(int count);
		
		int getCurrentTab();
		void setCurrentTab(int current);
		
		//Methods managing the position in the files loading of each log
		int getFileCount();
		void setFileCount(int count);
		
		int getCurrentFile();
		void setCurrentFile(int current);
		
		virtual void hide();
		
		
		bool isFirstLoading();
		void setFirstLoading(bool first);
		
	private:
		//Attributes managing the position in the tab loading
		int tabCount;
		int currentTab;
		
		//Attributes managing the position in the files loading of each log
		int fileCount;
		int currentFile;
		
		bool firstLoading;
		
		
};

#endif // _LOADING_DIALOG_H_
