
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knetload.h"
#include "version.h"

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kuniqueapplication.h>

static const char description[] =
    I18N_NOOP("A small network load meter for Kicker (the TDE panel).");
static const char message[] =
    I18N_NOOP("KNetLoad was first released on the 8th of August, 1999.");
static const char version[] = VERSION; /*VERSION;*/

int main(int argc, char **argv) {
    TDEAboutData aboutData("knetload", I18N_NOOP("KNetLoad"), version,
        description, TDEAboutData::License_GPL,
        "(c) 1999-2000, Markus Gustavsson\n"
        "(c) 2002, Ben Burton\n"
        "(c) 2004, Flameeyes",
        message, "http://flameeyes.web.ctonet.it/", "dgp85@users.sourceforge.net");

    aboutData.addAuthor("Markus Gustavsson", "Original author",
        "mighty@fragzone.se");
    aboutData.addAuthor("Ben Burton", "KDE3 rewrite, current maintainer",
        "bab@debian.org");
    aboutData.addAuthor("Flameeyes", "2.00 Version, maintainer",
        "dgp85@users.sourceforge.net");
    aboutData.addAuthor("Roland Riegel", "BSD and Solaris support",
        "feedback@roland-riegel.de");
    aboutData.addAuthor("Bill Wilson", "BSD and Solaris support",
        "bill@gkrellm.net");
    aboutData.addAuthor("Hajimu Umemoto", "BSD support",
        "ume@mahoroba.org");
    aboutData.addAuthor("Anthony Mallet", "BSD support",
        "anthony.mallet@useless-ficus.net");
    aboutData.addAuthor("Daisuke Yabuki", "Solaris support",
        "dxy@acm.org");

    aboutData.addCredit("Njaard, Charles Samuels",
        "Support and help with KDE", "charles@kde.org");
    aboutData.addCredit("rikkus, Rik Hemsley",
        "Support and help with KDE", "rik@kde.org");
    aboutData.addCredit("Mark Halpaap",
        "Independent port to KDE3", "mark.halpaap@gmx.net");
    aboutData.addCredit("Thanks to everyone in #KDE OpenProjects for "
        "being supportive and helpful!");

    TDECmdLineArgs::init(argc, argv, &aboutData);
    KUniqueApplication::addCmdLineOptions();

    if (! KUniqueApplication::start()) {
        fprintf(stderr, I18N_NOOP("KNetLoad is already running.\n"));
        return 1;
    }

    KUniqueApplication app;
    app.setMainWidget(new KNetLoad());
    return app.exec();
}
