/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/


#include "kmfgenericinterface_part.h"


// TQt includes
#include <tqlabel.h>

// KDE includes
#include <kinstance.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <tdeparts/genericfactory.h>

// Project includes
#include "kmfgenericinterface.h"

#include "../core/kmfnetwork.h"

#include "../kmfwidgets/kmfmainwindow.h"
namespace KMF {
KMFGenericInterfacePart::KMFGenericInterfacePart( TQWidget *parentWidget, const char *  widgetName ,
        TQObject *parent, const char *name,
        const TQStringList & /*args*/ )
		: KParts::ReadWritePart( parent, name ) {
	setInstance( KMFGenericInterfacePartFactory::instance() );

	m_genericinterface = new KMFGenericInterface( parentWidget, widgetName );

	
	m_app = dynamic_cast<KMFMainWindow*>( parent );
	if ( ! m_app ) {
		KMessageBox::error(0,"Oops wrong parent class found for kmfinstallerplugin!!!");
	}

	m_genericinterface->loadDoc( m_app->network() );
	connect( m_genericinterface, TQ_SIGNAL( sigTargetChanged() ),
		this, TQ_SLOT( slotTargetChanged() ) );
	
	connect( m_app, TQ_SIGNAL( sigUpdateView() ),
		m_genericinterface, TQ_SIGNAL( sigUpdateView() ) );

	connect( m_app, TQ_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_genericinterface, TQ_SIGNAL( sigUpdateView( NetfilterObject* ) ) );

	connect( m_app, TQ_SIGNAL( sigEnableActions( bool ) ),
		this, TQ_SLOT( slotEnableActions( bool ) ) );

	
	m_actionGoMyNetwork = new TDEAction( i18n( "&My Network" ), TQIconSet( BarIcon( "network", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoMyNetwork() ), actionCollection(), "my_network" );

	m_actionGoAccessControl = new TDEAction( i18n( "&Access Control" ), TQIconSet( BarIcon( "services", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoAccessControl() ), actionCollection(), "access_control" );


	m_actionGoSpecialHosts = new TDEAction( i18n( "&Special Hosts Control" ), TQIconSet( BarIcon( "network_local", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoSpecialHosts() ), actionCollection(), "special_hosts" );


	m_actionGoICMPOptions = new TDEAction( i18n( "&ICMP Options" ), TQIconSet( BarIcon( "pipe", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoICMPOptions() ), actionCollection(), "icmp_options" );

	
	m_actionGoNATConfiguration = new TDEAction( i18n( "&NAT Configuration" ), TQIconSet( BarIcon( "document-save-as", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoNATConfiguration() ), actionCollection(), "nat_configuration" );
	
	m_actionGoLogging = new TDEAction( i18n( "&Logging" ), TQIconSet( BarIcon( "text-x-log", KMFGenericInterfacePartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotGoLogging() ), actionCollection(), "logging_options" );


	setWidget( m_genericinterface );
	setXMLFile( "kmfgenericinterfacepartui.rc" );

	// we are read-write by default
	setReadWrite( true );

	// we are not modified since we haven't done anything yet
	setModified( false );

}

KMFGenericInterfacePart::~KMFGenericInterfacePart() {
	closeURL();
}

void KMFGenericInterfacePart::slotTargetChanged() {
	m_app->updateCaption();
}

void KMFGenericInterfacePart::setReadWrite( bool rw ) {
	ReadWritePart::setReadWrite( rw );
}

void KMFGenericInterfacePart::slotGoMyNetwork() {
	kdDebug() << "slotGoMyNetwork()" << endl;
	m_genericinterface->showPage( 0 );
}

void KMFGenericInterfacePart::slotGoAccessControl() {
	kdDebug() << "slotGoAccessControl()" << endl;
	m_genericinterface->showPage( 1 );
}

void KMFGenericInterfacePart::slotGoSpecialHosts() {
	kdDebug() << "slotGoSpecialHosts()" << endl;
	m_genericinterface->showPage( 2 );
}

void KMFGenericInterfacePart::slotGoICMPOptions() {
	kdDebug() << "slotGoICMPOptions()" << endl;
	m_genericinterface->showPage( 3 );
}

void KMFGenericInterfacePart::slotGoNATConfiguration() {
	kdDebug() << "slotGoNATConfiguration()" << endl;
	m_genericinterface->showPage( 4 );
}

void KMFGenericInterfacePart::slotGoLogging() {
	kdDebug() << "slotGoLogging()" << endl;
	m_genericinterface->showPage( 5 );
}


void KMFGenericInterfacePart::setModified( bool modified ) {
	// get a handle on our Save action and make sure it is valid
// 	TDEAction * save = actionCollection() ->action( KStdAction::stdName( KStdAction::Save ) );
// 	if ( !save )
// 		return ;
// 
// 	// if so, we either enable or disable it based on the current
// 	// state
// 	if ( modified )
// 		save->setEnabled( true );
// 	else
// 		save->setEnabled( false );

	// in any event, we want our parent to do it's thing
	ReadWritePart::setModified( modified );
}

bool KMFGenericInterfacePart::openFile() {
	// m_file is always local so we can use TQFile on it
	//     TQFile file(m_file);
	//     if (file.open(IO_ReadOnly) == false)
	//         return false;
	//
	//     // our example widget is text-based, so we use TQTextStream instead
	//     // of a raw TQDataStream
	//     TQTextStream stream(&file);
	//     TQString str;
	//     while (!stream.eof())
	//         str += stream.readLine() + "\n";
	//
	//     file.close();
	//
	//     // now that we have the entire file, display it
	// //     m_widget->setText(str);
	//
	//     // just for fun, set the status bar
	//     emit setStatusBarText( m_url.prettyURL() );

	return true;
}

bool KMFGenericInterfacePart::saveFile() {
	// if we aren't read-write, return immediately
	/*    if (isReadWrite() == false)
	        return false;

	    // m_file is always local, so we use TQFile
	    TQFile file(m_file);
	    if (file.open(IO_WriteOnly) == false)
	        return false;

	    // use TQTextStream to dump the text to the file
	    TQTextStream stream(&file);
	    stream << m_widget->text();

	    file.close();
	*/ 
	return true;
}

void KMFGenericInterfacePart::slotEnableActions( bool ) {
	kdDebug() << "void KMFGenericInterfacePart::slotEnableActions( bool )" << endl;
}

// bool KMFGenericInterfacePart::closeURL()
// {
//     return true;
// }

// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

TDEInstance* KMFGenericInterfacePartFactory::s_instance = 0L;
TDEAboutData* KMFGenericInterfacePartFactory::s_about = 0L;

KMFGenericInterfacePartFactory::KMFGenericInterfacePartFactory()
		: KParts::Factory() {}

KMFGenericInterfacePartFactory::~KMFGenericInterfacePartFactory() {
	delete s_instance;
	delete s_about;

	s_instance = 0L;
}

KParts::Part* KMFGenericInterfacePartFactory::createPartObject( TQWidget *parentWidget, const char *widgetName,
        TQObject *parent, const char *name,
        const char *classname, const TQStringList& args) {
	// Create an instance of our Part
	KMFGenericInterfacePart * obj = new KMFGenericInterfacePart( parentWidget, widgetName, parent, name ,args );

	// See if we are to be read-write or not
	if ( TQCString( classname ) == "KParts::ReadOnlyPart" )
		obj->setReadWrite( false );

	return obj;
}

TDEInstance* KMFGenericInterfacePartFactory::instance() {
	if ( !s_instance ) {
		s_about = new TDEAboutData( "kmfgenericinterfacepart", I18N_NOOP( "kmfgenericinterfacepartPart" ), "0.1" );
		s_about->addAuthor( "Christian Hubinger", 0, "chubinger@irrsinnig.org" );
		s_instance = new TDEInstance( s_about );
	}
	return s_instance;
}

extern "C" {
	TDE_EXPORT void* init_libkmfgenericinterfacepart() {
		return new KMFGenericInterfacePartFactory;
	}
}

}

#include "kmfgenericinterface_part.moc"
