/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_IBSFETCHER_H
#define TELLICO_FETCH_IBSFETCHER_H

#include "fetcher.h"
#include "configwidget.h"

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace TDEIO {
  class Job;
}

namespace Tellico {
  namespace Fetch {

/**
 * A fetcher for animenfo.com
 *
 * @author Robby Stephenson
 */
class IBSFetcher : public Fetcher {
TQ_OBJECT
  

public:
  IBSFetcher(TQObject* parent, const char* name = 0);
  virtual ~IBSFetcher() {}

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  // can search title, person, isbn, or keyword. No UPC or Raw for now.
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == ISBN || k == Keyword; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return IBS; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_);
    virtual void saveConfig(TDEConfigGroup&) {}
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);
  void slotCompleteISBN(TDEIO::Job* job);

private:
  Data::EntryPtr parseEntry(const TQString& str);

  TQByteArray m_data;
  int m_total;
  TQMap<int, Data::EntryPtr> m_entries;
  TQMap<int, KURL> m_matches;
  TQGuardedPtr<TDEIO::Job> m_job;

  bool m_started;
//  TQStringList m_fields;
};

  } // end namespace
} // end namespace
#endif
