/* This file is part of the KDE project
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KoDocumentIface_h__
#define __KoDocumentIface_h__

#include <dcopobject.h>
#include <tqvaluelist.h>
#include <dcopref.h>
#include <koffice_export.h>
class KoDocument;
class KDCOPActionProxy;

/**
 * DCOP interface for any KOffice document
 * Use KoApplicationIface to get hold of an existing document's interface,
 * or to create a document.
 *
 * Note: KOffice Applications may (and should) reimplement KoDocument::dcopObject()
 * In this case, don't look here... (unless the DCOP interface for the document
 * inherits KoDocumentIface, which is a good thing to do)
 */
class KOFFICECORE_EXPORT KoDocumentIface : public DCOPObject
{
    K_DCOP
public:

    KoDocumentIface( KoDocument * doc, const char * name = 0 );
    ~KoDocumentIface();

    /**
     * Generate a name for this interface. Automatically used if name=0 is
     * passed to the constructor
     */
    static TQCString newIfaceName();

k_dcop:
    /**
     * Returns the URL for this document (empty, real URL, or internal one)
     */
    TQString url();

    /**
     * Opens a document stored in @p url
     * Warning: this is asynchronous. The document might not be loaded yet when
     * this call returns. See isLoading.
     */
    void openURL( TQString url );

    /**
     * @return true is the document is still loading
     */
    bool isLoading();

    /**
     * @return true is the document has been modified
     */
    bool isModified();

    /**
     * @return the number of views this document is displayed in
     */
    int viewCount();

    /**
     * @return a DCOP reference (DCOPRef) to the view with index @p idx
     */
    DCOPRef view( int idx );

    /**
     * DCOP-action proxy
     */
    DCOPRef action( const TQCString &name );
    /**
     * @return list of actions
     */
    QCStringList actions();
    /**
     * @return a map of (action name, DCOP reference)
     */
    TQMap<TQCString,DCOPRef> actionMap();

    /**
     * Saves the document under its existing filename
     */
    void save();

    /**
     * Saves the document under a new name
     */
    void saveAs( const TQString & url );

    void setOutputMimeType( const TQCString & mimetype );

    TQString documentInfoAuthorName() const;
    TQString documentInfoEmail() const;
    TQString documentInfoCompanyName() const;
    TQString documentInfoTitle() const;
    TQString documentInfoAbstract() const;
    TQString documentInfoKeywords() const;
    TQString documentInfoSubject() const;
    TQString documentInfoTelephone() const;
    TQString documentInfoTelephoneWork() const;
    TQString documentInfoTelephoneHome() const;
    TQString documentInfoFax() const;
    TQString documentInfoCountry() const;
    TQString documentInfoPostalCode() const;
    TQString documentInfoCity() const;
    TQString documentInfoStreet() const;
    TQString documentInfoInitial() const;
    TQString documentInfoAuthorPostion() const;
    void setDocumentInfoAuthorName(const TQString & text);
    void setDocumentInfoEmail(const TQString &text);
    void setDocumentInfoCompanyName(const TQString &text);
    void setDocumentInfoTelephone(const TQString &text);
    void setDocumentInfoTelephoneWork(const TQString &text);
    void setDocumentInfoTelephoneHome(const TQString &text);
    void setDocumentInfoFax(const TQString &text);
    void setDocumentInfoCountry(const TQString &text);
    void setDocumentInfoTitle(const TQString & text);
    void setDocumentInfoPostalCode(const TQString &text);
    void setDocumentInfoCity(const TQString & text);
    void setDocumentInfoStreet(const TQString &text);
    void setDocumentInfoAbstract(const TQString &text);
    void setDocumentInfoInitial(const TQString & text);
    void setDocumentInfoKeywords(const TQString & text );
    void setDocumentInfoSubject(const TQString & text);
    void setDocumentInfoAuthorPosition(const TQString & text);

public:
    virtual QCStringList functionsDynamic();
    virtual bool processDynamic( const TQCString &fun, const TQByteArray &data,
                                 TQCString& replyType, TQByteArray &replyData );

protected:
    KoDocument * m_pDoc;
    KDCOPActionProxy *m_actionProxy;
};

#endif

