/* This file is part of the KDE project
   Copyright (C) 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexitooltip.h"

#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqpainter.h>
#include <tqimage.h>
#include <tqtooltip.h>
#include <tqfont.h>
#include <tqfontmetrics.h>
#include <tqtimer.h>


KexiToolTip::KexiToolTip(const TQVariant& value, TQWidget* parent)
 : TQWidget(parent, "KexiToolTip", TQt::WStyle_Customize | TQt::WType_Popup | TQt::WStyle_NoBorder 
	| TQt::WX11BypassWM | TQt::WDestructiveClose)
 , m_value(value)
{
	setPalette( TQToolTip::palette() );
	setFocusPolicy(TQWidget::NoFocus);
}

KexiToolTip::~KexiToolTip()
{
}

TQSize KexiToolTip::sizeHint() const
{
	TQSize sz(fontMetrics().boundingRect(m_value.toString()).size());
	return sz;
}

void KexiToolTip::show()
{
	updateGeometry();
	TQWidget::show();
}

void KexiToolTip::paintEvent( TQPaintEvent *pev )
{
	TQWidget::paintEvent(pev);
	TQPainter p(this);
	drawFrame(p);
	drawContents(p);
}

void KexiToolTip::drawFrame(TQPainter& p)
{
	p.setPen( TQPen(palette().active().foreground(), 1) );
	p.drawRect(rect());
}

void KexiToolTip::drawContents(TQPainter& p)
{
	p.drawText(rect(), TQt::AlignCenter, m_value.toString());
}

#include "kexitooltip.moc"
