/*
   This file is part of the KDE project
   Copyright (C) 2004 Nicolas GOUTTE <goutte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KWORD_1_3_DOCUMENT_H
#define KWORD_1_3_DOCUMENT_H

class TQIODevice;
class KTempFile;
class KWord13Picture;

#include <tqstring.h>
#include <tqmap.h>
#include <tqptrlist.h>
#include <tqdatetime.h>
#include <tqdict.h>
#include <tqstringlist.h>

#include "kword13frameset.h"

class KWord13Document
{
public:
    KWord13Document( void );
    ~KWord13Document( void );
    
public:
    void xmldump( TQIODevice* io );
    /// Get the "last printed" date/time
    TQDateTime lastPrintingDate( void ) const;
    /// Get the "creation" date/time
    TQDateTime creationDate( void ) const;
    /// Get the "modification" date/time
    TQDateTime modificationDate( void ) const;
    /**
     * Get a document info
     * \param name name of the document info
     */
    TQString getDocumentInfo( const TQString& name ) const;
    /**
     * Get a document property 
     * \param name name of the property
     * \param oldName alternative name of the property (in old KWord syntax)
     */
    TQString getProperty( const TQString& name, const TQString& oldName = TQString() ) const;
protected:
    /// Get a document property \internal
    TQString getPropertyInternal( const TQString& name ) const;
public:
    TQMap<TQString, TQString> m_documentProperties;
    TQMap<TQString, TQString> m_documentInfo; ///< From documentinfo.xml
    TQValueList<KWord13Layout> m_styles;
    TQPtrList<KWordTextFrameset> m_normalTextFramesetList; ///< List of \<FRAMESET\> having normal text
    TQPtrList<KWordTextFrameset> m_tableFramesetList; ///< List of \<FRAMESET\> being part of tables
    TQPtrList<KWordTextFrameset> m_headerFooterFramesetList; ///< List of \<FRAMESET\> having footer/header
    TQPtrList<KWordTextFrameset> m_footEndNoteFramesetList; ///< List of \<FRAMESET\> having footnotes or endnotes
    TQPtrList<KWord13PictureFrameset> m_pictureFramesetList; ///< List of \<FRAMESET\> having pictures
    TQPtrList<KWord13Frameset> m_otherFramesetList; ///< List of \<FRAMESET\> of other types
    TQDict<KWord13Picture> m_pictureDict; ///< "Dictionnary" of all pictures' data
    KTempFile* m_previewFile;
    TQStringList m_anchoredFramesetNames; ///< List of framesets that are anchored
};

#endif // KWORD_1_3_DOCUMENT_H
