/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef SETTINGSFILEIO_H
#define SETTINGSFILEIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqwidget.h>

class TQComboBox;
class TQCheckBox;
class TQSpinBox;
class KLineEdit;

namespace KBibTeX
{
    class SettingsFileIO : public TQWidget
    {
        TQ_OBJECT
    public:
        SettingsFileIO( TQWidget *parent = 0, const char *name = 0 );
        ~SettingsFileIO();

        void applyData();
        void readData();

    signals:
        void configChanged();

    protected slots:
        void slotConfigChanged();
        void slotBib2db5BasePath();
        void slotCheckBib2Db5Path();

    private:
        TQComboBox *m_comboBoxEncoding;
        TQComboBox *m_comboBoxStringDelimiters;
        TQComboBox *m_comboBoxKeywordCasing;
        TQCheckBox *m_checkBoxProtectCasing;
        TQComboBox *m_comboBoxLanguage;
        TQComboBox *m_comboBoxBibliographyStyle;
        TQCheckBox *m_checkBoxEmbedFiles;
        TQComboBox *m_comboBoxExportSystemHTML;
        TQCheckBox *m_checkBoxUseBibUtils;
        KLineEdit *m_lineeditBib2Db5Path;
        TQString m_bib2db5BasePath;
        TQSpinBox *m_spinBoxNumberOfBackups;

        void setupGUI();

    };
}

#endif
