/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXFILEIMPORTERBIBTEX_H
#define BIBTEXFILEIMPORTERBIBTEX_H

#include <iconv.h>

#include "fileimporter.h"
#include "entryfield.h"

namespace BibTeX
{

    class Element;
    class Comment;
    class Preamble;
    class Macro;
    class Entry;
    class Value;

    /**
    @author Thomas Fischer
    */
    class FileImporterBibTeX : public FileImporter
    {
    public:
        FileImporterBibTeX( bool personFirstNameFirst = false, TQString encoding = "latex" );
        ~FileImporterBibTeX();

        File* load( TQIODevice *iodevice );
        static bool guessCanDecode( const TQString & text );

        void setIgnoreComments( bool ignoreComments );

    public slots:
        void cancel();

    private:
        enum Token
        {
            tAt = 1, tBracketOpen = 2, tBracketClose = 3, tAlphaNumText = 4, tComma = 5, tAssign = 7, tDoublecross = 8, tEOF = 9, tUnknown = 0
        };

        bool cancelFlag;
        TQTextStream *m_textStream;
        bool m_personFirstNameFirst;
        TQChar m_currentChar;
        bool m_ignoreComments;
        char *m_lineBuffer;
        const int m_lineBufferSize;
        TQString m_encoding;
        TQString m_currentLine;
        unsigned int m_posIntCurrentLine;
        int m_currentLineNumber;

        Comment *readCommentElement();
        Comment *readPlainCommentElement();
        Macro *readMacroElement();
        Preamble *readPreambleElement();
        Entry *readEntryElement( const TQString& typeString );
        Element *nextElement();
        Token nextToken();
        TQString readString( bool &isStringKey );
        TQString readSimpleString( TQChar until = '\0' );
        TQString readQuotedString();
        TQString readLine();
        TQString readBracketString( const TQChar openingBracket );
        Token readValue( Value *value, EntryField::FieldType fieldType );

        void unescapeLaTeXChars( TQString &text );
        void splitPersons( const TQString& test, TQStringList &persons );
        void evaluateParameterComments( iconv_t &iconvHandle, const char *line );
        TQChar nextChar();
        TQString tokenidToString( Token token );
    };

}

#endif
