#include <hintlineedit.h>
#include <tqvbox.h>
#include <tqlabel.h>
#include <tqfont.h>

HintLineEdit::HintLineEdit( const TQString &hint, const TQString &text, TQWidget *parent, const char *name )
   : KLineEdit( text, 0, name )
   , m_vbox( new TQVBox( parent ) )
{
    init();
    m_hint->setText( hint );
}

HintLineEdit::HintLineEdit( const TQString &text, TQWidget *parent, const char *name )
   : KLineEdit( text, 0, name )
   , m_vbox( new TQVBox( parent ) )
{
    init();
}

HintLineEdit::HintLineEdit( TQWidget *parent, const char *name )
   : KLineEdit( 0, name )
   , m_vbox( new TQVBox( parent ) )
{
    init();
}

void
HintLineEdit::init()
{
    reparent( m_vbox, 0, TQPoint(0,0), true );
    m_hint = new TQLabel( m_vbox );
    //m_hint->setBuddy( this );
    m_hint->setFocusPolicy( TQWidget::NoFocus );
    TQFont font;
    font.setPointSize( font.pointSize() - 2);
    m_hint->setFont( font );
}

HintLineEdit::~HintLineEdit()
{
    reparent( 0, 0, TQPoint(0,0), false );
    delete m_vbox;
}

void
HintLineEdit::setHint( const TQString &hint )
{
    m_hint->setText( hint );
}

TQObject *
HintLineEdit::parent()
{
    return m_vbox->parent();
}

#include "hintlineedit.moc"
