/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef NYCGENERICIMPORTER_H
#define NYCGENERICIMPORTER_H

#include <tqstring.h>
#include <tqdatetime.h>

#include "baseimporter.h"
#include "datablocks/ingredientlist.h"
#include "datablocks/elementlist.h"

/** Class to import The NYC (Now You're Cooking) Generic Export file format.
  * @author Jason Kivlighn
  */
class NYCGenericImporter : public BaseImporter
{
public:
	NYCGenericImporter();
	~NYCGenericImporter();

protected:
	void parseFile( const TQString& filename );

private:
	void importNYCGeneric( TQTextStream &stream );
	void putDataInRecipe();
	void loadIngredientLine( const TQString & );

	Recipe m_recipe;
	TQString current_header;

	bool first;
};

#endif //NYCGENERICIMPORTER_H
