/*
 * status.cpp
 * Copyright (C) 1999-2008 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the implementation of the KBiffStatus
 * widget
 */
#include "status.h"
#include "status.moc"

#include <tdeapplication.h>
#include <tdelocale.h>

#include <tqdesktopwidget.h>
#include <tqpoint.h>
#include <tqrect.h>

#include <tqheader.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlistview.h>
#include <tqpoint.h>

KBiffStatus::KBiffStatus(TQWidget *parent_, const TQString& profile, const KBiffStatusList& list)
    : TQFrame(parent_, 0, WType_Popup),
      _listView(new TQListView(this))
{
    setFrameStyle(WinPanel|Raised);
    TQLabel *profile_label = new TQLabel(profile, this);
    profile_label->setFrameStyle(TQFrame::Box | TQFrame::Raised);
    profile_label->setAlignment(AlignCenter);

    _listView->addColumn(i18n("Mailbox"));
    _listView->addColumn(i18n("New"));
    _listView->addColumn(i18n("Old"));
    _listView->setColumnAlignment(1, AlignRight);
    _listView->setColumnAlignment(2, AlignRight);
    _listView->setSorting(1, false);
    _listView->setFrameStyle(TQFrame::WinPanel | TQFrame::Raised);
    _listView->setVScrollBarMode(TQScrollView::AlwaysOff);
    _listView->setHScrollBarMode(TQScrollView::AlwaysOff);
    _listView->header()->hide();

    updateListView(list);

    int list_height = (_listView->firstChild()->height() * list.count()) + 10;
    _listView->setFixedSize(_listView->sizeHint().width() + 5, list_height);
    resize(_listView->size());

    TQVBoxLayout *blayout = new TQVBoxLayout(this, 0, 0);
    blayout->addWidget(profile_label);
    blayout->addWidget(_listView);
}

KBiffStatus::~KBiffStatus()
{
}

void KBiffStatus::updateListView(const KBiffStatusList& list)
{
    _listView->clear();
    KBiffStatusListIterator it(list);
    for(it.toFirst(); it.current(); ++it)
    {
        if (it.current()->newMessages() == "-1")
        {
            new TQListViewItem(_listView, it.current()->mailbox(),
                              i18n("Disabled"));
        }
        else
        {
             new TQListViewItem(_listView, it.current()->mailbox(),
                               it.current()->newMessages(),it.current()->curMessages());
        }
    }
}

void KBiffStatus::popup(const TQPoint& pos_)
{
    TQDesktopWidget *desktop = TDEApplication::desktop();
    int cx = pos_.x(), cy = pos_.y();

    // for some reason, the width and height are incorrect until
    // we do the show.  so we show first (after hiding) and move later
    move(-100, -100);
    show();
 
    // verify that the width is within the desktop  
    if (desktop->isVirtualDesktop())
    {
	TQRect scn = desktop->screenGeometry(TQPoint(cx, cy));
	
	if ((pos_.x() + width()) > (scn.x() + scn.width()))
        {
	    cx = (scn.x() + scn.width()) - width();
            cx = (cx < 0) ? 0 : cx;
        }
    }   
    else
    {
        if ((pos_.x() + width()) > desktop->width())
	{
	    cx = pos_.x() - width();
	    cx = (cx < 0) ? 0 : cx;
        }
    }

    // verify that that height is within tolerances
    if ((pos_.y() + height()) > desktop->height())
    {
        cy = pos_.y() - height() - 2;
        cy = (cy < 0) ? 0 : cy;
    }

    // now that we have *real* co-ordinates, we move to them
    move(cx, cy+1);
}

KBiffStatusItem::KBiffStatusItem(const TQString& mailbox_, const int num_new,const int num_cur)
    : TQObject(),
      _mailbox(mailbox_),
      _newMessages(TQString().setNum(num_new)),
      _curMessages((num_cur==-1)?TQString("?"):TQString().setNum(num_cur))
{
}
KBiffStatusItem::KBiffStatusItem(const TQString& mailbox_, const int num_new)
    : TQObject(),
      _mailbox(mailbox_),
      _newMessages(TQString().setNum(num_new)),
      _curMessages(TQString("?"))
{
}

KBiffStatusItem::~KBiffStatusItem()
{
}
