/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�ien G�eau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// TQt
#include <tqbitmap.h>
#include <tqevent.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqtimer.h>

// KDE
#include <kdebug.h>

// Local
#include "fullscreenbar.moc"
namespace Gwenview {


const int FULLSCREEN_ICON_SIZE = 32;
const int FULLSCREEN_LABEL_RADIUS = 6;
// Intervals are in milliseconds
const int SLIDE_IN_INTERVAL = 4;
const int SLIDE_OUT_INTERVAL = 12;
// Step is in pixels
const int SLIDE_STEP = 4;


static void fillMask(TQPainter& painter, const TQRect& rect) {
	painter.fillRect(
		rect.left(),
		rect.top(),
		rect.width() - FULLSCREEN_LABEL_RADIUS,
		rect.height(),
		painter.brush());

	painter.fillRect(
		rect.right() - FULLSCREEN_LABEL_RADIUS + 1,
		rect.top(),
		FULLSCREEN_LABEL_RADIUS,
		rect.height() - FULLSCREEN_LABEL_RADIUS,
		painter.brush());

	painter.drawPie(
		rect.right() - 2*FULLSCREEN_LABEL_RADIUS + 1,
		rect.bottom() - 2*FULLSCREEN_LABEL_RADIUS + 1,
		FULLSCREEN_LABEL_RADIUS*2, FULLSCREEN_LABEL_RADIUS*2,
		0, -16*90);
}


enum BarState { OUT, SLIDING_OUT, SLIDING_IN, IN };


struct FullScreenBar::Private {
	TQTimer mTimer;
	BarState mState;
	bool mFirstShow;
};


FullScreenBar::FullScreenBar(TQWidget* parent)
: TDEToolBar(parent, "FullScreenBar") {
	d=new Private;
	d->mState=OUT;
	d->mFirstShow=true;
	setIconSize(FULLSCREEN_ICON_SIZE);
	setMovingEnabled(false);

	TQColor bg=colorGroup().highlight();
	TQColor fg=colorGroup().highlightedText();
	TQPalette pal(palette());
	pal.setColor(TQColorGroup::Background, bg);
	pal.setColor(TQColorGroup::Foreground, fg);
	pal.setColor(TQColorGroup::Button, bg);
	pal.setColor(TQColorGroup::ButtonText, fg);
	setPalette(pal);
	
	// Timer
	connect(&d->mTimer, TQ_SIGNAL(timeout()), this, TQ_SLOT(slotUpdateSlide()) );
}


FullScreenBar::~FullScreenBar() {
	delete d;
}


void FullScreenBar::resizeEvent(TQResizeEvent* event) {
	TDEToolBar::resizeEvent(event);

	// Create a mask
	TQPainter painter;
	TQBitmap mask(size(), true);
	painter.begin(&mask);
	painter.setBrush(TQt::white);
	fillMask(painter, rect());
	painter.end();
	
	setMask(mask);
}


void FullScreenBar::showEvent(TQShowEvent* event) {
	TDEToolBar::showEvent(event);
	// Make sure the bar position corresponds to the OUT state
	if (!d->mFirstShow) return;
	d->mFirstShow=false;
	move(0, -height());
	layout()->setResizeMode(TQLayout::Fixed);
}


void FullScreenBar::slideIn() {
	if (d->mState!=IN) {
		d->mState=SLIDING_IN;
		d->mTimer.start(SLIDE_IN_INTERVAL);
	}
}


void FullScreenBar::slideOut() {
	if (d->mState!=OUT) {
		d->mState=SLIDING_OUT;
		d->mTimer.start(SLIDE_OUT_INTERVAL);
	}
}


void FullScreenBar::slotUpdateSlide() {
	int pos=y();

	switch (d->mState) {
	case SLIDING_OUT:
		pos-=SLIDE_STEP;
		if (pos<=-height()) {
			d->mState=OUT;
			d->mTimer.stop();
		}
		break;
	case SLIDING_IN:
		pos+=SLIDE_STEP;
		if (pos>=0) {
			pos=0;
			d->mState=IN;
			d->mTimer.stop();
		}
		break;
	default:
		kdWarning() << k_funcinfo << "We should not get there\n";
	}
	move(0, pos);
}

} // namespace
