/***************************************************************************
                          audio.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AUDIO_H
#define AUDIO_H

#include "definitions.h"
#include <kurl.h>
#include <tdetempfile.h>

/**
  *@author Troy Corbin Jr.
  */

/*
		These represent the various sounds that can be played.
*/

const int SND_NONE						= 0x00;
const int SND_SELECT					= 0x01;
const int SND_MOVE						= 0x02;
const int SND_MATCH_OVER			= 0x03; // Deprecieated
const int SND_CHECK						= 0x04;
const int SND_FLAG						= 0x05;
const int SND_CHALLENGE				= 0x50;
const int SND_TELL						= 0x51;
const int SND_NOTIFICATION		= 0x52;
const int SND_DRAW_OFFER			= 0x53;
const int SND_SAY							= 0x54;
const int SND_PROMOTE					= 0x55;

class audioPrivate;
class audio
{
	public:
													audio();
													~audio();
		void									play( const int );
		void									setTheme( const TQString& );

		bool									enabled;
		int										volume;
		ThemeHeader						themeHeader;
	protected:
		void									prepFile( const TQString&, const int& );
	private:
		audioPrivate					*a;
};

#endif
