/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef JALV2_H
#define JALV2_H

#include "tools/base/tool_group.h"

namespace JALV2
{
//----------------------------------------------------------------------------
class Base : public Tool::Base
{
public:
  virtual TQString baseExecutable(bool, Tool::OutputExecutableType) const { return "jalv2"; }

private:
  virtual TQStringList checkExecutableOptions(bool) const { return TQStringList(); }
  virtual bool checkExecutableResult(bool withWine, TQStringList &lines) const;
};

//----------------------------------------------------------------------------
class Group : public Tool::Group
{
public:
  virtual TQString name() const { return "jalv2"; }
  virtual TQString label() const { return i18n("JAL V2"); }
  virtual TQString informationText() const;
  virtual bool hasDirectory(Compile::DirectoryType type) const { return type==Compile::DirectoryType::Header; }
  virtual Tool::Category checkDevicesCategory() const { return Tool::Category::Nb_Types; }
  virtual Tool::ExecutableType preferedExecutableType() const { return Tool::ExecutableType::Unix; }
  virtual Tool::CompileType compileType() const { return Tool::AllFiles; }
  virtual PURL::FileType implementationType(PURL::ToolType type) const { return (type==PURL::ToolType::Compiler ? PURL::JalSource : PURL::Nb_FileTypes); }

private:
  virtual BaseData baseFactory(Tool::Category c) const;
  virtual TQValueList<const Device::Data *> getSupportedDevices(const TQString &s) const;
  virtual Compile::Process *processFactory(const Compile::Data &data) const;
  virtual Compile::Config *configFactory(::Project *project) const;
  virtual Tool::SourceGenerator *sourceGeneratorFactory() const;
};

} // namespace

#endif
