/*
    This file is part of KOrganizer.

    Copyright (c) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KORG_NOPRINTER

#include "journalprint.h"

#include "calprintpluginbase.h"
#include <libkcal/journal.h>
#include <libkcal/calendar.h>
#include <libtdepim/kdateedit.h>
#include <tdeconfig.h>
#include <kdebug.h>

#include <tqbuttongroup.h>

#include "calprintjournalconfig_base.h"


class JournalPrintFactory : public KOrg::PrintPluginFactory {
  public:
    KOrg::PrintPlugin *create() { return new CalPrintJournal; }
};

K_EXPORT_COMPONENT_FACTORY( libkorg_journalprint, JournalPrintFactory )


/**************************************************************
 *           Print Journal
 **************************************************************/

TQWidget *CalPrintJournal::createConfigWidget( TQWidget *w )
{
  return new CalPrintJournalConfig_Base( w );
}

void CalPrintJournal::readSettingsWidget()
{
  CalPrintJournalConfig_Base *cfg =
      dynamic_cast<CalPrintJournalConfig_Base*>( mConfigWidget );
  if ( cfg ) {
    mFromDate = cfg->mFromDate->date();
    mToDate = cfg->mToDate->date();
    mUseDateRange = (cfg->mDateRangeGroup->selectedId() == 1);
  }
}

void CalPrintJournal::setSettingsWidget()
{
  CalPrintJournalConfig_Base *cfg =
      dynamic_cast<CalPrintJournalConfig_Base*>( mConfigWidget );
  if ( cfg ) {
    cfg->mFromDate->setDate( mFromDate );
    cfg->mToDate->setDate( mToDate );

    cfg->mDateRangeGroup->setButton( (mUseDateRange)?1:0 );
  }
}

void CalPrintJournal::loadConfig()
{
  if ( mConfig ) {
    mUseDateRange = mConfig->readBoolEntry( "JournalsInRange", false );
  }
  setSettingsWidget();
}

void CalPrintJournal::saveConfig()
{
  kdDebug(5850) << "CalPrintJournal::saveConfig()" << endl;

  readSettingsWidget();
  if ( mConfig ) {
    mConfig->writeEntry( "JournalsInRange", mUseDateRange );
  }
}

void CalPrintJournal::setDateRange( const TQDate& from, const TQDate& to )
{
  CalPrintPluginBase::setDateRange( from, to );
  CalPrintJournalConfig_Base *cfg =
      dynamic_cast<CalPrintJournalConfig_Base*>( mConfigWidget );
  if ( cfg ) {
    cfg->mFromDate->setDate( from );
    cfg->mToDate->setDate( to );
  }
}

void CalPrintJournal::print( TQPainter &p, int width, int height )
{
  int x=0, y=0;
  Journal::List journals( mCalendar->journals() );
  if ( mUseDateRange ) {
    Journal::List allJournals = journals;
    journals.clear();
    Journal::List::Iterator it = allJournals.begin();
    for ( ; it != allJournals.end(); ++it ) {
      TQDate dt = (*it)->dtStart().date();
      if ( mFromDate <= dt && dt <= mToDate ) {
        journals.append( *it );
      }
    }
  }

  TQRect headerBox( 0, 0, width, headerHeight() );
  TQRect footerBox( 0, height - footerHeight(), width, footerHeight() );
  height -= footerHeight();

  drawHeader( p, i18n("Journal entries"), TQDate(), TQDate(), headerBox );
  y = headerHeight() + 15;

  Journal::List::Iterator it = journals.begin();
  for ( ; it != journals.end(); ++it ) {
    drawJournal( *it, p, x, y, width, height );
  }

  drawFooter( p, footerBox );
}

#endif
