//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQColor;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQSize;

/**

 This class includes various pixmap-based graphical effects.
 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 		@short    This class includes various pixmap-based graphical effects.

*/
public class KPixmapEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KPixmapEffect(Class dummy){}

	public static final int VerticalGradient = 0;
	public static final int HorizontalGradient = 1;
	public static final int DiagonalGradient = 2;
	public static final int CrossDiagonalGradient = 3;
	public static final int PyramidGradient = 4;
	public static final int RectangleGradient = 5;
	public static final int PipeCrossGradient = 6;
	public static final int EllipticGradient = 7;

	public static final int Red = 0;
	public static final int Green = 1;
	public static final int Blue = 2;

	public static final int NorthLite = 0;
	public static final int NWLite = 1;
	public static final int WestLite = 2;
	public static final int SWLite = 3;
	public static final int SouthLite = 4;
	public static final int SELite = 5;
	public static final int EastLite = 6;
	public static final int NELite = 7;

	public KPixmapEffect() {
		newKPixmapEffect();
	}
	private native void newKPixmapEffect();
	/**
		 Creates a gradient from color a to color b of the specified type.
			@param pixmap The pixmap to process.
			@param ca Color a.
			@param cb Color b.
			@param type The type of gradient.
			@param ncols The number of colors to use when not running on a
		 truecolor display. The gradient will be dithered to this number of
		 colors. Pass 0 to prevent dithering.
				@return Returns the generated pixmap, for convenience.

		@short    Creates a gradient from color a to color b of the specified type.
	*/
	public static native KPixmap gradient(KPixmap pixmap, TQColor ca, TQColor cb, int type, int ncols);
	public static native KPixmap gradient(KPixmap pixmap, TQColor ca, TQColor cb, int type);
	/**
		 Creates an unbalanced gradient.
			 An unbalanced gradient is a gradient where the transition from
		 color a to color b is not linear, but in this case, exponential.
			@param pixmap The pixmap that should be written.
			@param ca Color a.
			@param cb Color b.
			@param type The type of gradient.
			@param xfactor The x decay length. Use a value between -200 and 200.
			@param yfactor The y decay length.
			@param ncols The number of colors. See #gradient.
				@return The generated pixmap, for convencience.

		@short    Creates an unbalanced gradient.
	*/
	public static native KPixmap unbalancedGradient(KPixmap pixmap, TQColor ca, TQColor cb, int type, int xfactor, int yfactor, int ncols);
	public static native KPixmap unbalancedGradient(KPixmap pixmap, TQColor ca, TQColor cb, int type, int xfactor, int yfactor);
	public static native KPixmap unbalancedGradient(KPixmap pixmap, TQColor ca, TQColor cb, int type, int xfactor);
	public static native KPixmap unbalancedGradient(KPixmap pixmap, TQColor ca, TQColor cb, int type);
	/**
		 Creates a pixmap of a given size with the given pixmap.
			 if the
		 given size is bigger than the size of the pixmap, the pixmap is
		 tiled.
			@param pixmap This is the source pixmap
			@param size The size the new pixmap should have.
				@return The generated, tiled pixmap.

		@short    Creates a pixmap of a given size with the given pixmap.
	*/
	public static native KPixmap createTiled(KPixmap pixmap, TQSize size);
	/**
		 Either brightens or dims a pixmap by a specified ratio.
			@param pixmap The pixmap to process.
			@param ratio The ratio to use. Use negative value to dim.
				@return Returns The pixmap(), provided for convenience.

		@short    Either brightens or dims a pixmap by a specified ratio.
	*/
	public static native KPixmap intensity(KPixmap pixmap, float ratio);
	/**
		 Modifies the intensity of a pixmap's RGB channel component.
			@param pixmap The pixmap to process.
			@param ratio value. Use negative value to dim.
			@param channel Which channel(s) should be modified
				@return Returns the pixmap(), provided for convenience.

		@short    Modifies the intensity of a pixmap's RGB channel component.
	*/
	public static native KPixmap channelIntensity(KPixmap pixmap, float ratio, int channel);
	/**
		 Blends the provided pixmap into a background of the indicated color.
			@param pixmap The pixmap to process.
			@param initial_intensity this parameter takes values from -1 to 1:

			<li>
			If positive, it tells how much to fade the image in its
			                              less affected spot.
			</li>

			<li>
			If negative, it tells roughly indicates how much of the image
			                              remains unaffected
			</li>
				@param bgnd Indicates the color of the background to blend in.
			@param eff Lets you choose what kind of blending you like.
			@param anti_dir Blend in the opposite direction (makes no much sense
		                  with concentric blending effects).
			@param ncols The number of colors to dither the pixmap to. Only
		                  used for 8 bpp pixmaps.
				@return Returns the pixmap(), provided for convenience.

		@short    Blends the provided pixmap into a background of the indicated color.
	*/
	public static native KPixmap blend(KPixmap pixmap, float initial_intensity, TQColor bgnd, int eff, boolean anti_dir, int ncols);
	public static native KPixmap blend(KPixmap pixmap, float initial_intensity, TQColor bgnd, int eff, boolean anti_dir);
	public static native KPixmap blend(KPixmap pixmap, float initial_intensity, TQColor bgnd, int eff);
	/**
		 Builds a hash on any given pixmap.
			@param pixmap The pixmap to process.
			@param lite The hash faces the indicated lighting (cardinal poles)
			@param spacing How many unmodified pixels inbetween hashes.
			@param ncols The number of colors to dither the pixmap to.
		 Only used for 8 bpp pixmaps.
				@return Returns The pixmap(), provided for convenience.

		@short    Builds a hash on any given pixmap.
	*/
	public static native KPixmap hash(KPixmap pixmap, int lite, int spacing, int ncols);
	public static native KPixmap hash(KPixmap pixmap, int lite, int spacing);
	public static native KPixmap hash(KPixmap pixmap, int lite);
	public static native KPixmap hash(KPixmap pixmap);
	/**
		 Creates a pattern from a pixmap.
			 The given pixmap is "flattened"
		 between color a to color b.
		 Doesn't change the original pixmap.
			@param pixmap The pixmap to process.
			@param size The size of the returned pixmap. If <code>size</code> is larger than
		 the original, the resulting pixmap will be tiled.
			@param ca Color a.
			@param cb Color b.
			@param ncols The number of colors to use. The image will be
		 dithered to this depth. Pass zero to prevent dithering.
				@return The resulting pixmap.

		@short    Creates a pattern from a pixmap.
	*/
	public static native KPixmap pattern(KPixmap pixmap, TQSize size, TQColor ca, TQColor cb, int ncols);
	public static native KPixmap pattern(KPixmap pixmap, TQSize size, TQColor ca, TQColor cb);
	/**
		 Fades a pixmap to a certain color.
			@param pixmap The pixmap to process.
			@param val The strength of the effect. 0 <= val <= 1.
			@param color The color to blend to.
				@return Returns the pixmap(), provided for convenience.

		@short    Fades a pixmap to a certain color.
	*/
	public static native KPixmap fade(KPixmap pixmap, double val, TQColor color);
	/**
		 Converts a pixmap to grayscale.
			@param pixmap The pixmap to process.
			@param fast Set to <code>true</code> in order to use a faster but non-photographic
		 quality algorithm. Appropriate for things such as toolbar icons.
				@return Returns the pixmap(), provided for convenience.

		@short    Converts a pixmap to grayscale.
	*/
	public static native KPixmap toGray(KPixmap pixmap, boolean fast);
	public static native KPixmap toGray(KPixmap pixmap);
	/**
		 Desaturates a pixmap.
			@param pixmap The pixmap to process.
			@param desat A value between 0 and 1 setting the degree of desaturation
				@return Returns The pixmap(), provided for convenience.

		@short    Desaturates a pixmap.
	*/
	public static native KPixmap desaturate(KPixmap pixmap, float desat);
	public static native KPixmap desaturate(KPixmap pixmap);
	/**
		 Modifies the contrast of a pixmap.
			@param pixmap The pixmap to process.
			@param c A contrast value between -255 and 255.
				@return Returns the pixmap(), provided for convenience.

		@short    Modifies the contrast of a pixmap.
	*/
	public static native KPixmap contrast(KPixmap pixmap, int c);
	/**
		 Dithers a pixmap using Floyd-Steinberg dithering for low-color
		 situations.
			@param pixmap The pixmap to process.
			@param palette The color palette to use.
			@param size The size of the palette.
				@return Returns the pixmap(), provided for convenience.

		@short    Dithers a pixmap using Floyd-Steinberg dithering for low-color  situations.
	*/
	public static native KPixmap dither(KPixmap pixmap, TQColor palette, int size);
	/**
		 Calculate a 'selected' pixmap, for instance a selected icon
		 on the desktop.
			@param pixmap the pixmap to select
			@param col the selected color, usually from TQColorGroup.highlight().
		     		@short    Calculate a 'selected' pixmap, for instance a selected icon  on the desktop.
	*/
	public static native KPixmap selectedPixmap(KPixmap pixmap, TQColor col);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
