// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
//using System.IO;
using System.Collections;

namespace QtCSharp {

	public class TQType {

		string name, access, iname;
		bool isInterface, isConverted, isTQObject;
		ArrayList qancestors, qenums, qctors, qdctors, qmethods;

		public TQType ()
		{
			qancestors = new ArrayList ();
			qenums = new ArrayList ();
			qctors = new ArrayList ();
			qdctors = new ArrayList ();
			qmethods = new ArrayList ();
		}

		public void AddTQAncestor (TQAncestor qancestor)
		{
			qancestors.Add (qancestor);
		}

		public void AddTQEnum (TQEnum qenum)
		{
			qenums.Add (qenum);
		}

		public void AddTQCtor (TQCtor qctor)
		{
			qctors.Add (qctor);
		}

		public void AddTQDCtor (TQDCtor qdctor)
		{
			qdctors.Add (qdctor);
		}

		public void AddTQMethod (TQMethod qmethod)
		{
			qmethods.Add (qmethod);
		}

		public string Name
		{
			get {return name;}
			set {name = value;}
		}

		public string Access
		{
			get {return access;}
			set {access = value;}
		}

		public bool IsInterface
		{
			get {return isInterface;}
			set {isInterface = value;}
		}
		
		public bool IsConverted
		{
			get {return isConverted;}
			set {isConverted = value;}
		}

		public bool IsTQObject {
			get { return isTQObject; }
			set { isTQObject = value; }
		}

		public string IName
		{
			get {return iname;}
			set {iname = value;}
		}

		public ArrayList TQAncestors
		{
			get {return qancestors;}
		}

		public ArrayList TQEnums
		{
			get {return qenums;}
		}

		public ArrayList TQCtors
		{
			get {return qctors;}
		}

		public ArrayList TQDCtors
		{
			get {return qdctors;}
		}

		public ArrayList TQMethods
		{
			get {return qmethods;}
			set {qmethods = value;}
		}
	}
}
