/*
 *  Copyright (C) 2004 Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>
 
#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kjs/interpreter.h>

#include <kjsembed/jsconsolewidget.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsfactory.h>
#include <kjsembed/kjsembedpart.h>
#include <kjsembed/jssecuritypolicy.h>

using namespace KJSEmbed;

int main( int argc, char **argv )
{
    TDEAboutData about( "test-kjsembed", I18N_NOOP("KJS Embed Test For C++ access of variables and functions."), "0.1",
		      I18N_NOOP("Test"),
		      TDEAboutData::License_LGPL, I18N_NOOP("(c) 2004 Ian Reinhart Geiser") );
    TDECmdLineArgs::init( argc, argv, &about );
    TDEApplication app;

    // Setup Interpreter
    KJSEmbed::JSSecurityPolicy::setDefaultPolicy( KJSEmbed::JSSecurityPolicy::CapabilityAll );
    KJSEmbed::KJSEmbedPart *part = new KJSEmbed::KJSEmbedPart;
    KJS::Interpreter *js = part->interpreter();
    KJS::ExecState *exec = js->globalExec();

    TQString script = 	"var foobar = \"test from javascript.\";"
    			"function testNoArgsFunction( ){ return foobar; }"
			"function testNoReturnFunction( value ){ foobar = value; }"
    			"function testFunction( value ){ return \"testFunction dorks with \" + value;}";
    KJS::Value returnValue = part->evaluate(script,js->globalObject());
    if( returnValue.isValid() && !returnValue.toBoolean(exec ) )
    	kdWarning() << "Script failed to run." << endl;
    
    /**
    * Test extraction of a Variant from javascript
    */
    TQString value = part->getVariant("foobar").toString();
    if(  value != "test from javascript." )
    	kdWarning() << "Get variant failed with: " << value << endl;

    /**
    * Test manipulation of a Variant from C++
    */
    part->putVariant("foobar", "test from C++.");
    value = part->getVariant("foobar").toString();
    if(  value != "test from C++." )
    	kdWarning() << "Put variant failed with: " << value << endl;
    
    /**
    * Test to see if a function is present
    */
    if( !part->hasMethod("testFunction") )
    	kdWarning() << "error finding testFunction" << endl;
	
    if( part->hasMethod("foobar") )
    	kdWarning() << "error i found a value and was looking for a method" << endl;
    /**
    * Test calling function that takes an arg, and returns a value.
    */
    KJS::List args;
    args.append(KJS::String("C++ String"));
    value = part->callMethod("testFunction", args).toString(exec).qstring();
    if ( value != "testFunction dorks with C++ String" )
    	kdWarning() << "error calling testFunction, wanted \"testFunction dorks with C++ String\" but got " << value << endl;
    	
    /**
    * Test calling function that takes an arg, and returns nothing.
    */
    args.clear();
    args.append(KJS::String("C++ String"));
    returnValue = part->callMethod("testNoReturnFunction", args);
    if ( returnValue.isNull() )
    	kdWarning() << "error calling testNoReturnFunction is suppose to be null and was " << returnValue.toString(exec).qstring() << endl;
    /**
    * Test calling function that takes no args, and returns a value
    */
    args.clear();
    value = part->callMethod("testNoArgsFunction", args).toString(exec).qstring();
    if ( value != "C++ String" )
    	kdWarning() << "error calling testNoArgsFunction, wanted \"C++ String\" but got " << value << endl;
   return 1;
}
