/***************************************************************************
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <tqvbox.h>
#include <tqdialog.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <kgenericfactory.h>

#include "dccoptionsplugin.h"

#include "optiontabs.h"

K_EXPORT_COMPONENT_FACTORY( libkdevdccoptions, KGenericFactory<DccOptionsPlugin>( "kdevdccoptions" ) )

DccOptionsPlugin::DccOptionsPlugin(TQObject *parent, const char *name, const TQStringList/* &args*/)
    : KDevCompilerOptions(parent, name)
{
}

DccOptionsPlugin::~DccOptionsPlugin()
{
}

TQString DccOptionsPlugin::exec(TQWidget *parent, const TQString &flags)
{
    DccOptionsDialog *dlg = new DccOptionsDialog(parent, "dcc options dialog");
    TQString newFlags = flags;
    dlg->setFlags(flags);
    if(dlg->exec() == TQDialog::Accepted)
        newFlags = dlg->flags();
    delete dlg;
    return newFlags;
}


DccOptionsDialog::DccOptionsDialog( TQWidget * parent, const char * name )
    : KDialogBase(Tabbed, i18n("Delphi Compiler Options"), Ok|Cancel, Ok, parent, name, true)
{
    TQVBox *vbox;

    vbox = addVBoxPage(i18n("General"));
    general = new GeneralTab(vbox, "general tab");

    vbox = addVBoxPage(i18n("Locations I"));
    locations = new LocationsTab(vbox, "locations tab");

    vbox = addVBoxPage(i18n("Locations II"));
    locations2 = new Locations2Tab(vbox, "locations2 tab");

    vbox = addVBoxPage(i18n("Code Generation"));
    codegen = new CodegenTab(vbox, "codegen tab");

    vbox = addVBoxPage(i18n("Debug && Optimization"));
    debug_optim = new DebugOptimTab(vbox, "debug and optim tab");

    vbox = addVBoxPage(i18n("Linker"));
    linker = new LinkerTab(vbox, "linker tab");
}

DccOptionsDialog::~DccOptionsDialog( )
{
}

void DccOptionsDialog::setFlags( const TQString & flags )
{
    TQStringList flaglist = TQStringList::split(" ", flags);

    general->readFlags(&flaglist);
    codegen->readFlags(&flaglist);
    debug_optim->readFlags(&flaglist);
    locations->readFlags(&flaglist);
    locations2->readFlags(&flaglist);
    linker->readFlags(&flaglist);

    unrecognizedFlags = flaglist;
}

TQString DccOptionsDialog::flags( ) const
{
    TQStringList flaglist;

    general->writeFlags(&flaglist);
    locations->writeFlags(&flaglist);
    locations2->writeFlags(&flaglist);
    codegen->writeFlags(&flaglist);
    debug_optim->writeFlags(&flaglist);
    linker->writeFlags(&flaglist);

    TQString flags;
    TQStringList::ConstIterator li;
    for (li = flaglist.begin(); li != flaglist.end(); ++li) {
        flags += (*li);
        flags += " ";
    }

    for (li = unrecognizedFlags.begin(); li != unrecognizedFlags.end(); ++li) {
        flags += (*li);
        flags += " ";
    }

    flags.truncate(flags.length()-1);
    return flags;
}

#include "dccoptionsplugin.moc"
