// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef CMODULE_H
#define CMODULE_H

#include <noatun/pref.h>
#include "query.h"

class TDEListView;
class KLineEdit;
class TQDialog;
class Oblique;
class TQCheckBox;
class TQComboBox;
class TQPushButton;
class TQTabWidget;

class SchemaConfig : public TQWidget
{
TQ_OBJECT
  
	Oblique *mOblique;

	TDEListView *mSchemaTree;
	KLineEdit *mPropertyEdit, *mValueEdit, *mPresentationEdit;
	TQComboBox *mSchemaList;

	TQCheckBox *mOptionPlayable, *mOptionChildrenVisible, *mOptionAutoOpen;

	TQPushButton *mAdd, *mRemove, *mCopy;

	TQPushButton *mAddSibling, *mAddChild, *mRemoveSelf;

	TQDialog *mRegexpEditor;
	bool mIgnore;

	struct QueryItem
	{
		Query query;
		TQString title;
		bool changed;
	};

	TQMap<TQString, QueryItem> mQueries;

public:
	SchemaConfig(TQWidget *parent, Oblique *oblique);

	Oblique *oblique() { return mOblique; }

	void reopen();
	void save();

	static TQString nameToFilename(const TQString &name);
	static TQString filenameToName(const TQString &filename);

public slots:
	void newSchema();
	void copySchema();
	void removeSchema();

	void selectSchema(const TQString &title);

	void addSibling();
	void addChild();
	void removeSelf();

	void setCurrentModified();

private slots:
	void editValueRegexp();

	void setCurrent(TQListViewItem *_item);
	void updateCurrent();

	void move(TQListViewItem *item, TQListViewItem *afterFirst, TQListViewItem *afterNow);

private:
	QueryItem *currentQuery();
};

class SliceListItem;

class SliceConfig : public TQWidget
{
TQ_OBJECT
  
	Oblique *mOblique;
	TDEListView *mSliceList;
	TQPushButton *mAdd, *mRemove;
	TQValueList<SliceListItem*> mAddedItems;
	TQValueList<Slice*> mRemovedItems;

public:
	SliceConfig(TQWidget *parent, Oblique *oblique);
	Oblique *oblique() { return mOblique; }

	void reopen();
	void save();


	SliceListItem *currentItem();

private slots:
	void addSibling();
	void removeSelf();
};

class Configure : public CModule
{
TQ_OBJECT
  
	TQTabWidget *tabs;
	SchemaConfig *schema;
	SliceConfig *slice;

public:
	Configure(Oblique *parent);

	virtual void reopen();
	virtual void save();
};


#endif
