/***************************************************************************
                          kpybrowser.h  -  description
                             -------------------
    begin                : Fri Aug 24 15:11:58 MST 2001
    copyright            : (C) 2001 by Christian Bird
    email                : chrisb@lineo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPYBROWSER_H
#define KPYBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdelistview.h>
#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqtooltip.h>
#include <tqdict.h>
#include "pybrowsenode.h"


/** KPyBrowser is the base class of the project */
class KPyBrowser : public TDEListView
{
  TQ_OBJECT
  
  public:
    /** construtor */
    KPyBrowser(TQWidget* parent=0, const char *name=0);
    /** destructor */
    ~KPyBrowser();
    void parseText(TQString &pytext);

        //used by KPBToolTip to dynamically create the needed tooltip
        void tip (const TQPoint &p, TQRect &r, TQString &str);

	private:
		PyBrowseNode *class_root, *function_root;

        //create a mapping of names to nodes
        TQDict<PyBrowseNode> node_dict;

	public slots:
		void nodeSelected(TQListViewItem *node);
	signals:
		void selected(TQString, int);
    private:
        class KPBToolTip : public TQToolTip
        {
            public:
                KPBToolTip(TQWidget *parent);
            protected:
                void maybeTip( const TQPoint & );
        };
        KPBToolTip* tooltip;
};

#endif
