/***************************************************************************
                          projectnewweb.h  -  description
                             -------------------
    begin                : Fri Oct 27 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon <pdima@users.sourceforge.net,yshurik@penguinpowered.com,sequitur@easystreet.com>
                           (C) 2002 Andras Mantia
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROJECTNEWWEB_H
#define PROJECTNEWWEB_H

//qt includes
#include <tqwidget.h>
#include <tqstringlist.h>

//app includes
#include "projectnewwebs.h"

/**
  *@author Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon
  */

class TDEProcess;
class KURL;

class ProjectNewWeb : public ProjectNewWebS  {
   TQ_OBJECT
  
public:
  ProjectNewWeb(TQWidget *parent=0, const char *name=0);
  ~ProjectNewWeb();

public slots:
  void enableStart(const TQString&);
  void setCommandL(const TQString&);
  void setBaseURL(const KURL& a_baseURL);

  void slotStart();

  KURL::List files();

  void slotGetWgetExited(TDEProcess *);
  void slotGetWgetOutput(TDEProcess *proc, char *buffer, int buflen);

  virtual void resizeEvent( TQResizeEvent * );

signals:

  void enableMessagesWidget();

  void messages(const TQString& );
  /** No descriptions */
  void enableNextButton(TQWidget *,bool);

private:
  KURL baseURL;

  bool start;

  TDEProcess *proc;

private slots: // Private slots
  /** No descriptions */
  void setProtocol(const TQString& protocol);
};

#endif
