/***************************************************************************
                          phpnewclassdlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 11 2001
    copyright            : (C) 2001 by Sandy Meier
    email                : smeier@kdevelop.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "phpnewclassdlg.h"
#include <klineedit.h>
#include <kcompletion.h>
#include <tdefiledialog.h>
#include <tqtoolbutton.h>
#include <iostream>
#include <tqregexp.h>
#include <tqtextedit.h>
#include <tdeglobal.h>
#include <tdestandarddirs.h>
#include <tdeinstance.h>
#include <kdebug.h>

using namespace std;

PHPNewClassDlg::PHPNewClassDlg(const TQStringList& baseClassNames,const TQString& directory,TQWidget *parent, const char *name) : PHPNewClassDlgBase(parent,name,true) {
  m_filenameModified = false;
  TDECompletion *comp = new TDECompletion();
  comp->setItems(baseClassNames);
  m_dirEdit->setText(directory);

  // load the class template if available
  TQString templateFile = TDEGlobal::instance()->dirs()->findResource("data","kdevphpsupport/newclasstemplate.txt");
  if(!templateFile.isNull()){
    TQFile file(templateFile);
    TQTextStream stream(&file);
    if(file.open(IO_ReadOnly)){ 
      m_classTemplate->setText(stream.read());
      file.close();
    }
  }
 
  
  m_baseClassEdit->setCompletionObject( comp ); /// @todo change it to KLineEdit
  connect(m_baseClassEdit,TQ_SIGNAL(returnPressed(const TQString&)),comp,TQ_SLOT(addItem(const TQString&)));
  connect(m_classNameEdit,TQ_SIGNAL(textChanged(const TQString&)),
	  this,TQ_SLOT(classNameTextChanged(const TQString&)));
  connect(m_fileNameEdit,TQ_SIGNAL(textChanged(const TQString&)),
	  this,TQ_SLOT(fileNameTextChanged(const TQString&)));
  connect(m_dirButton,TQ_SIGNAL(clicked()),
	  this,TQ_SLOT(slotDirButtonClicked()));
}
PHPNewClassDlg::~PHPNewClassDlg(){
}

void PHPNewClassDlg::slotDirButtonClicked(){
  TQString dir = KFileDialog::getExistingDirectory(m_dirEdit->text(),this);
  if(!dir.isEmpty()){
    m_dirEdit->setText(dir);
  }
}
void PHPNewClassDlg::classNameTextChanged(const TQString& str){
  if(!m_filenameModified){
    m_fileNameEdit->setText(str.lower() + ".inc");  
  }
}

void PHPNewClassDlg::fileNameTextChanged(const TQString&){
  if(m_fileNameEdit->hasFocus()){
    m_filenameModified = true;
  }
}
void PHPNewClassDlg::accept(){
  PHPNewClassDlgBase::accept(); // hide the dialog
 
  TQString text = m_classTemplate->text();
  TQString classDir = m_dirEdit->text();
  if(!classDir.endsWith("/")) classDir += "/"; // append /
  TQString absFileName = classDir + m_fileNameEdit->text();
  
  // save the template for the next time
  TQString templateDir = TDEGlobal::instance()->dirs()->saveLocation("data") + "/kdevphpsupport/";
  TQString templateFile = templateDir + "newclasstemplate.txt";
  TQDir dir(templateDir);
  if(!dir.exists()){
    if(!dir.mkdir(templateDir)){
      kdWarning() << "Error on creating directory for the classtemplate" << templateDir << endl;
    }
  }
  TQFile file(templateFile); 
  TQTextStream stream(&file);
  
  if(file.open(IO_WriteOnly)){
    stream << text; // write
    file.close();
  }

  // generate the sourcecode for the class
  if(m_baseClassEdit->text().isEmpty()){
    text = text.replace(TQRegExp("extends BASECLASS"),"");
    text = text.replace(TQRegExp("BASECLASS\\:\\:BASECLASS\\(\\);"),"");
  }else{
    text = text.replace(TQRegExp("BASECLASS"),m_baseClassEdit->text());
  }
  text = text.replace(TQRegExp("CLASSNAME"),m_classNameEdit->text());
  text = text.replace(TQRegExp("FILENAME"),m_fileNameEdit->text().upper());
  text = text.replace(TQRegExp("AUTHOR"),"not implemented");
 
  file.setName(absFileName);
  if(file.open(IO_WriteOnly)){
    stream << text; // write
    file.close();
  }
}

#include "phpnewclassdlg.moc"
