/****************************************************************************
 *   Copyright (C) 2001 by Hugo Varotto										*
 *   hugo@varotto-usa.com													*
 *																			*
 *	 Based on Kate's fileselector widget	by									*
 *          Matt Newell														*
 *			(C) 2001 by Matt Newell											*
 *			newellm@proaxis.com												*
 *																			*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by		*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version										*
 *																			*
 ***************************************************************************/

#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqstrlist.h>
#include <tqtooltip.h>
#include <tqregexp.h>

#include <kxmlguiclient.h>
#include <kiconloader.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kprotocolinfo.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kcombobox.h>

#include <kdebug.h>

#include "fileselectorwidget.h"
#include <tdediroperator.h>
#include <kcombiview.h>
#include <tdefilepreview.h>
#include <tdefileview.h>
#include <tdefileitem.h>
#include <kimagefilepreview.h>

#include "autoprojectwidget.h"
#include "autoprojectpart.h"
#include "kdevlanguagesupport.h"

#include "tdefilednddetailview.h"
#include "tdefiledndiconview.h"

KDnDDirOperator::KDnDDirOperator ( const KURL &urlName, TQWidget* parent, const char* name ) : KDirOperator ( urlName, parent, name )
{

}

KFileView* KDnDDirOperator::createView( TQWidget* parent, KFile::FileView view )
{
    KFileView* new_view = 0L;

    if( (view & KFile::Detail) == KFile::Detail ) {
        new_view = new KFileDnDDetailView( parent, "detail view");
    }
    else if ((view & KFile::Simple) == KFile::Simple ) {
        new_view = new KFileDnDIconView( parent, "simple view");
        new_view->setViewName( i18n("Short View") );
    }

    return new_view;
}


FileSelectorWidget::FileSelectorWidget(AutoProjectPart* part, KFile::Mode mode, TQWidget* parent, const char* name ) : TQWidget(parent, name)
{
    m_part = part;

	// widgets and layout
	TQVBoxLayout* lo = new TQVBoxLayout(this);

	TQHBox *hlow = new TQHBox (this);
	lo->addWidget(hlow);

	home = new TQPushButton( hlow );
	home->setPixmap(SmallIcon("go-home"));
	TQToolTip::add(home, i18n("Home directory"));
	up = new TQPushButton( /*i18n("&Up"),*/ hlow );
	up->setPixmap(SmallIcon("go-up"));
	TQToolTip::add(up, i18n("Up one level"));
	back = new TQPushButton( /*i18n("&Back"),*/ hlow );
	back->setPixmap(SmallIcon("back"));
	TQToolTip::add(back, i18n("Previous directory"));
	forward = new TQPushButton( /*i18n("&Next"),*/ hlow );
	forward->setPixmap(SmallIcon("forward"));
	TQToolTip::add(forward, i18n("Next directory"));

	// HACK
	TQWidget* spacer = new TQWidget(hlow);
	hlow->setStretchFactor(spacer, 1);
	hlow->setMaximumHeight(up->height());

	cmbPath = new KURLComboBox( KURLComboBox::Directories, true, this, "path combo" );
	cmbPath->setSizePolicy( TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
	KURLCompletion* cmpl = new KURLCompletion();
	cmbPath->setCompletionObject( cmpl );
	lo->addWidget(cmbPath);

	dir = new KDnDDirOperator(KURL(), this, "operator");
	dir->setView(KFile::Simple);
    dir->setMode(mode);

	lo->addWidget(dir);
	lo->setStretchFactor(dir, 2);

	TQHBox* filterBox = new TQHBox(this);
	filterIcon = new TQLabel(filterBox);
	filterIcon->setPixmap( BarIcon("filter") );
	filter = new KHistoryCombo(filterBox, "filter");
	filter->setSizePolicy( TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
	filterBox->setStretchFactor(filter, 2);
	lo->addWidget(filterBox);

	// slots and signals
	connect( filter, TQ_SIGNAL( textChanged(const TQString&) ), TQ_SLOT( slotFilterChanged(const TQString&) ) );
	connect( filter, TQ_SIGNAL( activated(const TQString&) ), TQ_SLOT( slotFilterChanged(const TQString&) ) );
	connect( filter, TQ_SIGNAL( returnPressed(const TQString&) ), TQ_SLOT( filterReturnPressed(const TQString&) ) );

	connect( home, TQ_SIGNAL( clicked() ), dir, TQ_SLOT( home() ) );
	connect( up, TQ_SIGNAL( clicked() ), dir, TQ_SLOT( cdUp() ) );
	connect( back, TQ_SIGNAL( clicked() ), dir, TQ_SLOT( back() ) );
	connect( forward, TQ_SIGNAL( clicked() ), dir, TQ_SLOT( forward() ) );

	connect( cmbPath, TQ_SIGNAL( urlActivated( const KURL&  )), this,  TQ_SLOT( cmbPathActivated( const KURL& ) ));
	//connect( cmbPath, TQ_SIGNAL( returnPressed( const TQString&  )), this,  TQ_SLOT( cmbPathReturnPressed( const TQString& ) ));
	connect( dir, TQ_SIGNAL(urlEntered(const KURL&)), this, TQ_SLOT(dirUrlEntered(const KURL&)) );

	connect( dir, TQ_SIGNAL(finishedLoading()), this, TQ_SLOT(dirFinishedLoading()) );

//    dirUrlEntered( dir->url() );

    TQStringList list;

    /* read the file patterns from the project DOM */
    TQDomElement docEl = m_part->projectDom()->documentElement();
    TQDomElement fileviewEl = docEl.namedItem("kdevfileview").toElement();
    TQDomElement groupsEl = fileviewEl.namedItem("groups").toElement();
    TQDomElement groupEl = groupsEl.firstChild().toElement();

    while ( !groupEl.isNull() )
    {
        if (groupEl.tagName() == "group")
        {
            list << groupEl.attribute("pattern").replace ( TQRegExp ( ";" ), " " ) + " (" + groupEl.attribute("name") + ")";
        }
        groupEl = groupEl.nextSibling().toElement();
    }

    filter->setHistoryItems ( list );

}


FileSelectorWidget::~FileSelectorWidget()
{
}

void FileSelectorWidget::dragEnterEvent ( TQDragEnterEvent* /*ev*/ )
{
}

void FileSelectorWidget::dropEvent ( TQDropEvent* /*ev*/ )
{
    kdDebug ( 9020 ) << "Dropped" << endl;

    TQString path = "Something was dropped in the Destination directory file-selector";

    emit dropped ( path );

}

void FileSelectorWidget::filterReturnPressed ( const TQString& nf )
{
    // KURL u ( m_part->project()->projectDirectory() );
    setDir ( nf );
}

void FileSelectorWidget::slotFilterChanged( const TQString & nf )
{
  dir->setNameFilter( nf );
  dir->updateDir();
}

void FileSelectorWidget::cmbPathActivated( const KURL& u )
{
   dir->setURL( u, true );
}

void FileSelectorWidget::cmbPathReturnPressed( const TQString& u )
{
   dir->setFocus();
   dir->setURL( KURL(u), true );
}


void FileSelectorWidget::dirUrlEntered( const KURL& u )
{
   cmbPath->removeURL( u );
   TQStringList urls = cmbPath->urls();
   urls.prepend( u.url() );
   while ( urls.count() >= (uint)cmbPath->maxItems() )
      urls.remove( urls.last() );
   cmbPath->setURLs( urls );
}


void FileSelectorWidget::dirFinishedLoading()
{
   // HACK - enable the nav buttons
   // have to wait for diroperator...
   up->setEnabled( dir->actionCollection()->action( "up" )->isEnabled() );
   back->setEnabled( dir->actionCollection()->action( "back" )->isEnabled() );
   forward->setEnabled( dir->actionCollection()->action( "forward" )->isEnabled() );
   home->setEnabled( dir->actionCollection()->action( "home" )->isEnabled() );
}


void FileSelectorWidget::focusInEvent(TQFocusEvent*)
{
   dir->setFocus();
}

void FileSelectorWidget::setDir( KURL u )
{
  dir->setURL(u, true);
}

void FileSelectorWidget::setDir(const TQString& path)
{
    KURL u ( path );
    dir->setURL ( u, true );
}


#include "fileselectorwidget.moc"

