/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the Artistic License.
*/
#ifndef __topic_h__
#define __topic_h__

#include <kactivelabel.h>
#include <tqtextedit.h>
#include <tqlineedit.h>
#include <tqpopupmenu.h>
#include <tqguardedptr.h>

class KSircTopicEditor;

class KSircTopic : public KActiveLabel
{
    TQ_OBJECT
  
public:
    KSircTopic( TQWidget *parent, const char *name = 0 );

public slots:
    virtual void setText( const TQString &);

signals:
    void topicChange( const TQString &newTopic );

protected:
    virtual void contentsMouseDoubleClickEvent( TQMouseEvent * );
    virtual void contentsMouseReleaseEvent( TQMouseEvent * );
    virtual void fontChange(TQFont &);

private slots:
    void setNewTopic();
    void slotEditResized();
    void doResize();

private:


    TQGuardedPtr<KSircTopicEditor> m_editor;
    bool m_doEdit;
    int m_height;
    TQString m_text;
};

class KSircTopicEditor : public TQTextEdit
{
    TQ_OBJECT
  
public:
    KSircTopicEditor( TQWidget *parent, const char *name = 0 );

signals:
    void resized();

public slots:
    virtual void slotMaybeResize();

protected:
    virtual void keyPressEvent( TQKeyEvent *ev );
    virtual void focusOutEvent( TQFocusEvent * );
    virtual TQPopupMenu *createPopupMenu( const TQPoint &pos );

private:
    TQGuardedPtr<TQPopupMenu> m_popup;
};

#endif
