#ifndef PWIDGET_H
#define PWIDGET_H

class PWidget;

#include <tqobject.h>
#include <tqwidget.h>
#include "pobject.h"
#include "pmessage.h"

class PWidget : public PObject
{
  TQ_OBJECT
  
 public:
  PWidget(PObject *parent = 0);
  virtual ~PWidget();

  // Init and setup code
  static PObject *createWidget(CreateArgs &ca);

  virtual void messageHandler(int fd, PukeMessage *pm);

  virtual void setWidget(TQObject *w = 0x0);
  virtual TQWidget *widget();

 protected:
  bool eventFilter(TQObject *o, TQEvent *e);

 private:
  TQWidget *w;

  void (PWidget::*eventList[20])(TQObject *, TQEvent *);

  void eventNone(TQObject *, TQEvent *);
  void eventTimer(TQObject *, TQEvent *);
  void eventMouse(TQObject *, TQEvent *);
  void eventKey(TQObject *, TQEvent *);
  void eventFocus(TQObject *, TQEvent *);
  void eventPaint(TQObject *, TQEvent *);
  void eventMove(TQObject *, TQEvent *);
  void eventResize(TQObject *, TQEvent *);

};

#endif
