/*
    kopetewindow.h  -  Kopete Main Window

    Copyright (c) 2001-2002 by Duncan Mac-Vicar Prett <duncan@kde.org>
    Copyright (c) 2001-2002 by Stefan Gehn            <metz AT gehn.net>
    Copyright (c) 2002-2003 by Martijn Klingens       <klingens@kde.org>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETEWINDOW_H
#define KOPETEWINDOW_H

#include <tqptrdict.h>

#include <tdemainwindow.h>
#include <tqlabel.h>

class TQHBox;
class TQTimer;
class TQSignalMapper;

class TQMouseEvent;
class TQPoint;

class TDEAction;
class TDEActionMenu;

class TDEGlobalAccel;
class TDESelectAction;
class KSqueezedTextLabel;
class TDEToggleAction;

class KopeteAccountStatusBarIcon;
class KopeteContactListView;
class KopetePluginConfig;
class KopeteSystemTray;
class KopeteEditGlobalIdentityWidget;

namespace Kopete
{
class AwayAction;
class Account;
class Contact;
class Plugin;
class Protocol;
}

/**
 * @author Duncan Mac-Vicar P. <duncan@kde.org>
 */
class KopeteWindow : public TDEMainWindow
{
	TQ_OBJECT
  

public:
	KopeteWindow ( TQWidget *parent = 0, const char *name = 0 );
	~KopeteWindow();

	virtual bool eventFilter( TQObject* o, TQEvent* e );

protected:
	virtual void closeEvent( TQCloseEvent *ev );
	virtual void leaveEvent( TQEvent* ev );
	virtual void showEvent( TQShowEvent* ev );

private slots:
	void showMenubar();
	void showStatusbar();
	void slotToggleShowOffliners();
	void slotToggleShowEmptyGroups();
	void slotConfigChanged();
	void slotConfNotifications();
	void slotConfToolbar();
	void slotUpdateToolbar();
	void slotConfigurePlugins();
	void slotConfGlobalKeys();
	void slotShowHide();
	void slotToggleAway();

	/* show the global status message selector menu
	 */
	void setStatusMessage( const TQString & );
	
	/**
	 * Checks if the mousecursor is in the contact list.
	 * If not, the window will be hidden.
	 */
	void slotAutoHide();

	/**
	 * This slot will apply settings that change the
	 * contactlist's appearance. Only autohiding is
	 * handled here at the moment
	 */
	void slotContactListAppearanceChanged();

	/**
	 * This slot will set all the protocols to away
	 */
	void slotGlobalAway();
	void slotGlobalBusy();
	void slotGlobalAvailable();
	void slotSetInvisibleAll();
	void slotDisconnectAll();

	void slotQuit();

	/**
	 * Get a notification when a plugin is loaded, so we can merge
	 * XMLGUI cruft
	 */
	void slotPluginLoaded( Kopete::Plugin *p );

	/**
	 * Get a notification when an account is created, so we can add a status bar
	 * icon
	 */
	void slotAccountRegistered( Kopete::Account *a );

	/**
	 * Cleanup the status bar icon when the account is destroyed
	 */
	void slotAccountUnregistered( const Kopete::Account *a);

	/**
	 * The status icon got changed, update it.
	 * @param contact The account's contact that changed.
	 */
	void slotAccountStatusIconChanged( Kopete::Contact * contact);

	/**
	 * The status icon of some account changed. Must be sent by the account in question.
	 */
	void slotAccountStatusIconChanged();

	/**
	 * Show a context menu for a protocol
	 */
//	void slotProtocolStatusIconRightClicked( Kopete::Protocol *proto, const TQPoint &p );

	/**
	 * Show a context menu for an account
	 */
	void slotAccountStatusIconRightClicked( Kopete::Account *a,
		const TQPoint &p );

	void slotTrayAboutToShowMenu(TDEPopupMenu *);

	/**
	 * Show the Add Contact wizard
	 */
	void showAddContactDialog( Kopete::Account * );

	/**
	 * Show the Export Contacts wizards
	 */
	void showExportDialog();

	/**
	 * Enable the Connect All and Disconnect All buttons here
	 * along with connecting the accountRegistered and accountUnregistered
	 * signals.
	 */
	void slotAllPluginsLoaded();
	
	/**
	 * Protected slot to setup the Set Global Status Message menu.
	 */
	void slotBuildStatusMessageMenu();
	void slotStatusMessageSelected( int i );
	void slotNewStatusMessageEntered();

        /**
         * Show the set global status message menu when clicking on the icon in the status bar.
         */
        void slotGlobalStatusMessageIconClicked( const TQPoint &position );

	/**
	 * Extracts protocolId and accountId from the single TQString argument signalled by a TQSignalMapper,
	 * get the account, and call showAddContactDialog.
	 * @param accountIdentifer TQString of protocolId and accountId, concatenated with TQChar( 0xE000 )
	 * We need both to uniquely identify an account, but TQSignalMapper only emits one TQString.
	 */
	void slotAddContactDialogInternal( const TQString & accountIdentifier );
	
public:
	KopeteContactListView *contactlist;

	// Some Actions
	TDEActionMenu* actionAddContact;

	//TDEActionMenu* actionConnectionMenu;
	//TDEAction* actionConnect;
	TDEAction* actionDisconnect;
	TDEAction* actionExportContacts;

	TDEActionMenu* actionAwayMenu;
	TDEActionMenu* actionDockMenu;
	TDEAction* selectAway;
	TDEAction* selectBusy;
	TDEAction* actionSetAvailable;
	TDEAction* actionSetInvisible;


	TDEAction* actionPrefs;
	TDEAction* actionQuit;
	TDEAction* actionSave;
	TDEToggleAction *menubarAction;
	TDEToggleAction *statusbarAction;
	TDEToggleAction *actionShowOffliners;
	TDEToggleAction *actionShowEmptyGroups;
	TDEGlobalAccel *globalAccel;

	KopeteEditGlobalIdentityWidget *editGlobalIdentityWidget;
private:
	void initView();
	void initActions();
	void initSystray();
	void loadOptions();
	void saveOptions();

	void makeTrayToolTip();
	void startAutoHideTimer();

	virtual bool queryClose();
	virtual bool queryExit();
private:
	int docked;
	bool hidden;
	int deskRight;
	TQPoint position;
	TQHBox *m_statusBarWidget;
	KopeteSystemTray *m_tray;
	bool m_autoHide;
	unsigned int m_autoHideTimeout;
	TQTimer* m_autoHideTimer;
	TQSignalMapper* addContactMapper;

	KopetePluginConfig *m_pluginConfig;

	/**
	 * This is really a dictionary of KopeteAccountStatusBarIcon objects, but
	 * TQPtrDict requires a full class definition to be known to make
	 * that work. And since I don't want to include that whole file here,
	 * use TQObject instead.
	 */
	TQPtrDict<TQObject> m_accountStatusBarIcons;
	KSqueezedTextLabel * m_globalStatusMessage;
	TDEPopupMenu * m_globalStatusMessageMenu;
	TQLineEdit * m_newMessageEdit;
	TQString m_globalStatusMessageStored;
};


class GlobalStatusMessageIconLabel : public TQLabel
{
      TQ_OBJECT
  
public:
      GlobalStatusMessageIconLabel(TQWidget *parent = 0, const char *name = 0);

protected:
      void mouseReleaseEvent(TQMouseEvent *event);

signals:
      void iconClicked(const TQPoint &position);

};

#endif
