// fontprogress.cpp
//
// (C) 2001--2004 Stefan Kebekus
// Distributed under the GPL

#include <config.h>

#include "fontprogress.h"

#include <kdebug.h>
#include <tdelocale.h>
#include <tdeprocio.h>
#include <kprogress.h>
#include <tqapplication.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqvariant.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <tqvbox.h>

/* 
 *  Constructs a fontProgressDialog which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
fontProgressDialog::fontProgressDialog(const TQString& helpIndex, const TQString& label, const TQString& abortTip, const TQString& whatsThis, const TQString& ttip, TQWidget* parent, const TQString& name, bool progressbar)
  : KDialogBase( parent, "Font Generation Progress Dialog", true, name, Cancel, Cancel, true )
{
  setCursor( TQCursor( 3 ) );

  setButtonCancel(KGuiItem(i18n("Abort"), "process-stop", abortTip));

  if (helpIndex.isEmpty() == false) {
    setHelp(helpIndex, "kdvi");
    setHelpLinkText( i18n( "What's going on here?") ); 
    enableLinkedHelp(true);
  } else
    enableLinkedHelp(false);

  TQVBox *page = makeVBoxMainWidget();

  TextLabel1   = new TQLabel( label, page, "TextLabel2" );
  TextLabel1->setAlignment( int( TQLabel::AlignCenter ) );
  TQWhatsThis::add( TextLabel1, whatsThis );
  TQToolTip::add( TextLabel1, ttip );

  if (progressbar) {
    ProgressBar1 = new KProgress( page, "ProgressBar1" );
    ProgressBar1->setFormat(i18n("%v of %m"));
    TQWhatsThis::add( ProgressBar1, whatsThis );
    TQToolTip::add( ProgressBar1, ttip );
  } else 
    ProgressBar1 = NULL;
  
  TextLabel2   = new TQLabel( "", page, "TextLabel2" );
  TextLabel2->setAlignment( int( TQLabel::AlignCenter ) );
  TQWhatsThis::add( TextLabel2, whatsThis );
  TQToolTip::add( TextLabel2, ttip );

  progress = 0;
  procIO = 0;
  tqApp->connect(this, TQ_SIGNAL(finished()), this, TQ_SLOT(killProcIO()));
}


/*  
 *  Destroys the object and frees any allocated resources
 */

fontProgressDialog::~fontProgressDialog()
{
    // no need to delete child widgets, TQt does it all for us
}


void fontProgressDialog::increaseNumSteps(const TQString& explanation)
{
  if (ProgressBar1 != 0)
    ProgressBar1->setProgress(progress++);
  TextLabel2->setText( explanation );
}


void fontProgressDialog::setTotalSteps(int steps, TDEProcIO *proc)
{
  procIO = proc;
  if (ProgressBar1 != 0) {
    ProgressBar1->setTotalSteps(steps);
    ProgressBar1->setProgress(0);
  }
  progress = 0;
}


void fontProgressDialog::killProcIO()
{
  if (!procIO.isNull())
    procIO->kill();
}


#include "fontprogress.moc"
