/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Jul  8 09:57:28 CEST 2000
    copyright            : (C) 2000 by Artur Rataj
    email                : art@zeus.polsl.gliwice.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <kdebug.h>

#include "kcoloredit.h"

static const char description[] =
	I18N_NOOP("KColorEdit");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static TDECmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("File to open"), 0 },
  TDECmdLineLastOption
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	TDEAboutData aboutData( "kcoloredit", I18N_NOOP("KColorEdit"),
		VERSION, description, TDEAboutData::License_GPL,
		"(c) 2000, Artur Rataj");
	aboutData.addAuthor("Artur Rataj",0, "art@zeus.polsl.gliwice.pl");
    aboutData.addCredit( "Nadeem Hasan", I18N_NOOP( "Rewrote UI code "
        "to be KDE standards compliant" ), "nhasan@kde.org" );
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  TDEApplication app;

  if (app.isRestored())
  {
    RESTORE(KColorEditApp);
  }
  else
  {
    KColorEditApp *kcoloredit = new KColorEditApp();
    kcoloredit->show();

    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

		if (args->count())
		{
        kcoloredit->openDocumentFile(args->arg(0));
		}
		else
		{
		  kcoloredit->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}
