// Copyright (c) 2002-2004 Rob Kaper <cap@capsi.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#include <stdlib.h>

#include <tqtextstream.h>

#include <tdeversion.h>
#undef KDE_3_1_FEATURES
#ifdef TDE_MAKE_VERSION
#if TDE_VERSION > TDE_MAKE_VERSION (3, 1, 0)
#define KDE_3_1_FEATURES
#endif
#endif
#include <tdeio/slavebase.h>
#include <tdeinstance.h>
#include <tdeprocess.h>

#include "tdeio_atlantik.h"
#include "libatlantic_export.h"

extern "C"
{
	int LIBATLANTIC_EXPORT kdemain( int, char **argv )
	{
		TDEInstance instance( "tdeio_atlantik" );
		AtlantikProtocol slave(argv[2], argv[3]);
		slave.dispatchLoop();
		return 0;
	}
}

void AtlantikProtocol::get( const KURL& url )
{
	TDEProcess *proc = new TDEProcess;
	*proc << "atlantik";

#ifdef KDE_3_1_FEATURES
	TQString host = url.hasHost() ? url.host() : TDEProcess::quote( url.queryItem("host") );
#else
	TQString host = url.hasHost() ? url.host() : url.queryItem("host");
#endif
	TQString port = TQString::number( url.port() ? url.port() : 1234 );
	int game = url.queryItem("game").toInt();
	TQString gameString = game ? TQString::number( game ) : TQString();

	if (!host.isNull() && !port.isNull())
	{
		*proc << "--host" << host << "--port" << port;
		if (!gameString.isNull())
			*proc << "--game" << gameString;
	}

	proc->start(TDEProcess::DontCare);
	proc->detach();
	finished();
}
