/*
 * KAsteroids - Copyright (c) Martin R. Jones 1997
 *
 * Part of the KDE project
 */

#ifndef __KAST_TOPLEVEL_H__
#define __KAST_TOPLEVEL_H__

#include <tdemainwindow.h>
#include <tdeaccel.h>
#include <tqdict.h>
#include <tqmap.h>

#include "view.h"

//#define KA_ENABLE_SOUND

class KALedMeter;
class TQLCDNumber;
class KDialogBase;

class KAstTopLevel : public TDEMainWindow
{
    TQ_OBJECT
  
public:
    KAstTopLevel();
    virtual ~KAstTopLevel();

private:
    void initTDEAction();
    void playSound( const char *snd );
    void readSoundMapping();
    void doStats();
    bool queryExit();
    bool processKeyPress( TQKeyEvent *event );
    bool processKeyRelease( TQKeyEvent *event );

protected:
    virtual bool eventFilter( TQObject *object, TQEvent *event );
    virtual void focusInEvent( TQFocusEvent *event );
    virtual void focusOutEvent( TQFocusEvent *event );

private slots:
    void loadSettings();
    void slotNewGame();
    void slotGameOver();

    void slotShipKilled();
    void slotRockHit( int size );
    void slotRocksRemoved();

    void slotUpdateVitals();

    void slotKeyConfig();
    void slotPref();
    void slotShowHighscores();

    void slotPause();
    void slotLaunch();

private:
    KAsteroidsView *view;
    TQLCDNumber *scoreLCD;
    TQLCDNumber *levelLCD;
    TQLCDNumber *shipsLCD;

    TQLCDNumber *teleportsLCD;
//    TQLCDNumber *bombsLCD;
    TQLCDNumber *brakesLCD;
    TQLCDNumber *shieldLCD;
    TQLCDNumber *shootLCD;
    KALedMeter *powerMeter;

    TQDict<TQString> soundDict;

    // waiting for user to press Enter to launch a ship
    bool waitShip;
    bool gameOver;

    int shipsRemain;
    int score;
    int level;

    enum Action { Invalid, Launch, Thrust, RotateLeft, RotateRight, Shoot,
                    Teleport, Brake, Shield };

    TQMap<Action, TDEAction*> keycodes;

    TDEAction *launchAction;
};

#endif

