import java.util.*;

import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;
/*
    $Id$

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1996 Bernd Johannes Wuebben
                       wuebben@math.cornell.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

*/

/**
 *  Class to test TDEFontDialog widgets.
 *
 *  This is a translation to java from tdefontdialogtest.cpp in the tests library
 *  of tdeui source.
 *
 * @see TDEFontDialog
 * @see TDEApplication
 * @see TDEConfig
 *
 * @author Bernd Johannes Wuebben, java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */
public class TDEFontDialogTest {

   static String description = "Java TDEFontDialog test program.";
   static String[][] options = {   };
   static String VERSION = "0.1";

   public static void main(String[] cmdLineArgs) {

      TDEAboutData aboutData = new TDEAboutData( "tdefontdialogtest", "TDEFontDialogTest",
         VERSION, description, TDEAboutData.License_GPL,
         "(c) 2002, Kenneth J. Pouncey");
      aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
      TDECmdLineArgs.init( cmdLineArgs, aboutData );
      TDECmdLineArgs.addCmdLineOptions( options ); // Add our own options.

      TDEApplication app = new TDEApplication();

      // parse the args
      TDECmdLineArgs args = TDECmdLineArgs.parsedArgs();

      TDEConfig aConfig = new TDEConfig();
      aConfig.setGroup( "TDEFontDialog-test" );

      // parameters are Font name, Font Point Size, Font Style, Font Italic
      app.setFont(new TQFont("Helvetica",12,TQFont.Normal,false));
//      app.setFont(new TQFont("Times",18,TQFont.Bold,true));

      TQFont font = aConfig.readFontEntry( "Chosen" );

      int nRet = TDEFontDialog.getFont(font);

      // return values from TDEFontDialog
      //    nRet = 1 for OK Button
      //    nRet = 0 for Cancel button

      if (nRet == 1) { // print out font values
         System.out.println("Ok Button pressed from TDEFontDialog ");
         System.out.println("   Font name selected: " + font.family());
         System.out.println("   Font Point Size selected: " + font.pointSize());
         System.out.println("   Font Bold?: " + font.bold());
         System.out.println("   Font Italic?: " + font.italic());
         System.out.println("   Font Underline?: " + font.underline());
//         System.out.println("   Font Character Set: " + getCharacterSet(font.charSet()));
         System.out.println("   Font raw name selected: " + font.rawName());
      }

      int[] flags = { 0 };

      //Static method for TDEFontDialog needs to be generated
      nRet = TDEFontDialog.getFontDiff(font, flags);
      if (nRet == 1) {
         System.out.println("Ok Button pressed from TDEFontDialog diff dialog ");
         System.out.println("   Font diff flags: " + flags[0]);
         System.out.println("   Font name selected: " + font.family());
         System.out.println("   Font Point Size selected: " + font.pointSize());
         System.out.println("   Font Bold?: " + font.bold());
         System.out.println("   Font Italic?: " + font.italic());
         System.out.println("   Font Underline?: " + font.underline());
         System.out.println("   Font raw name selected: " + font.rawName());
      }

      // This should save off the font chose in the configuration so it can
      //    be read next time.
      aConfig.writeEntry( "Chosen", font,true,false,false );

      aConfig.sync();

      app.exec();
      return;
   }

   /**
    * Returns the string representation of the character set.
    *    Others should be added here.
    */
/*   private static String getCharacterSet (int cs) {

      switch (cs) {

         case TQFont.ISO_8859_1 :
            return "ISO_8859_1";
         case TQFont.ISO_8859_2 :
            return "ISO_8859_2";
         case TQFont.ISO_8859_3 :
            return "ISO_8859_3";
         case TQFont.ISO_8859_4 :
            return "ISO_8859_4";
         case TQFont.ISO_8859_5 :
            return "ISO_8859_5";
         case TQFont.ISO_8859_6 :
            return "ISO_8859_6";
         case TQFont.ISO_8859_7 :
            return "ISO_8859_7";
         case TQFont.ISO_8859_8 :
            return "ISO_8859_8";
         case TQFont.ISO_8859_9 :
            return "ISO_8859_9";
         case TQFont.ISO_8859_10 :
            return "ISO_8859_10";
         case TQFont.ISO_8859_11 :
            return "ISO_8859_11";
         case TQFont.ISO_8859_12 :
            return "ISO_8859_12";
         case TQFont.ISO_8859_13 :
            return "ISO_8859_13";
         case TQFont.ISO_8859_14 :
            return "ISO_8859_14";
         case TQFont.ISO_8859_15 :
            return "ISO_8859_15";

         // more should be added
         default :
            return " other ";

      }
   } */
	static {
		qtjava.initialize();
		tdejava.initialize();
	}

}
