//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQObject;

/**

 A Trader interface, similar to the CORBA Trader.
 Basically, it provides a way for an application to query
 all KDE services (that is, applications and components) that match
 a specific set of requirements.  This allows you to find an
 application in real-time without you having to hard-code the name
 and/or path of the application.  It is mostly used when you want to
 do complex queries that KServiceTypeProfile can't handle.
 \par Examples
 A few examples will make this a lot more clear.
 Say you have an application that will display HTML.  In this
 example, you don't want to link to tdehtml... and furthermore, you
 really don't care if the HTML browser is ours or not, as long as
 it works.  The way that you formulate your query as well as the way
 that you execute the browser depends on whether or not you want the
 browser to run stand-alone or embedded.
 If you want the browser to run standalone, then you will limit the
 query to search for all services that handle 'text/html' <b>and</b>,
 furthermore, they must be applications (Type=Application).  You
 then will use KRun.run() to invoke the application.  In "trader-speak",
 this looks like so:
 <pre>
 ArrayList offers = TDETrader.self().query("text/html", "Type == 'Application'");
 KService.Ptr ptr = offers.first();
 KURL.List lst;
 lst.append("http://www.kde.org/index.html");
 KRun.run(ptr, lst);
 </pre>
 It should be noted that in the above example, using
 KServiceTypeProfile would be the better choice since you would
 probably want the preferred service and the trader doesn't take
 this into account.  The trader does allow you to do more complex
 things, though.  Say, for instance, you want to only choose
 Netscape.  You can do it with the constraint: "(Type ==
 'Application') and (Name == 'Netscape')"
 More the likely, though, you will only use the trader for such
 things as finding components.  In our continuing example, we say
 that we want to load any KParts component that can handle HTML.  We
 will need to use the KLibFactory and KLibLoader to
 actually do something with our query, then.  Our code would look
 like so:
 <pre>
 ArrayList offers = TDETrader.self().query("text/html", "'KParts/ReadOnlyPart' in ServiceTypes");
 KService.Ptr ptr = offers.first();
 KLibFactory factory = KLibLoader.self().factory( ptr.library() );
 if (factory)
   part = static_cast<KParts.ReadOnlyPart >(factory.create(this, ptr.name(), "KParts.ReadOnlyPart"));
 </pre>
 Please note that when including property names containing arithmetic operators like - or +, then you have
 to put brackets around the property name, in order to correctly separate arithmetic operations from
 the name. So for example a constraint expression like
  X-TDE-Blah < 4
 needs to be written as
 [X-TDE-Blah] < 4
 otherwise it could also be interpreted as
 Substract the numeric value of the property "KDE" and "Blah" from the property "X" and make sure it
 is less than 4.
 Instead of the other meaning, make sure that the numeric value of "X-TDE-Blah" is less than 4.
 See also the formal syntax defined in {@link #tradersyntax} .
		@author Torben Weis <weis@kde.org>

		@short Provides a way to query the KDE infrastructure for specific         applications or components.

*/
public class TDETrader extends TQObject  {
	protected TDETrader(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 The main function in the TDETrader class.
			 It will return a list of services that match your
		 specifications.  The only required parameter is the service
		 type.  This is something like 'text/plain' or 'text/html'.  The
		 constraint parameter is used to limit the possible choices
		 returned based on the constraints you give it.
			 The <code>constraint</code> language is rather full.  The most common
		 keywords are AND, OR, NOT, IN, and EXIST, all used in an
		 almost spoken-word form.  An example is:
		 <pre>
		 (Type == 'Service') and (('KParts/ReadOnlyPart' in ServiceTypes) or (exist Exec))
		 </pre>
			 The keys used in the query (Type, ServiceType, Exec) are all
		 fields found in the .desktop files.
			@param servicetype A service type like 'text/plain', 'text/html', or 'KOfficePlugin'.
			@param constraint A constraint to limit the choices returned, null to
		                    get all services of the given <code>servicetype</code>
			@param preferences Indicates a particular preference to return, null to ignore.
		                    Uses an expression in the constraint language that must return
		                    a number
				@return A list of services that satisfy the query

		@short    The main function in the TDETrader class.
		@see #http://developer#kde#org/documentation/library/kdetqt/tradersyntax#html
	*/
	public native ArrayList query(String servicetype, String constraint, String preferences);
	public native ArrayList query(String servicetype, String constraint);
	public native ArrayList query(String servicetype);
	/**
		 A variant of query(), that takes two service types as an input.
		 It is not exactly the same as adding the second service type
		 in the constraints of the other query call, because this one
		 takes into account user preferences for this combination of service types.
			 Example usage:
		 To get list of applications that can handle a given mimetype,
		 set <code>servicetype</code> to the mimetype and <code>genericServiceType</code> is "Application".
		 To get list of embeddable components that can handle a given mimetype,
		 set <code>servicetype</code> to the mimetype and <code>genericServiceType</code> is "KParts/ReadOnlyPart".
			@param servicetype A service type like 'text/plain', 'text/html', or 'KOfficePlugin'.
			@param genericServiceType a basic service type, like 'KParts/ReadOnlyPart' or 'Application'
			@param constraint A constraint to limit the choices returned, null to
		                    get all services of the given <code>servicetype</code>
			@param preferences Indicates a particular preference to return, null to ignore.
		                    Uses an expression in the constraint language that must return
		                    a number
				@return A list of services that satisfy the query

		@short    A variant of query(), that takes two service types as an input.
		@see #http://developer#kde#org/documentation/library/kdetqt/tradersyntax#html
	*/
	public native ArrayList query(String servicetype, String genericServiceType, String constraint, String preferences);
	/**
		 This is a static pointer to a TDETrader instance.
			  You will need
		 to use this to access the TDETrader functionality since the
		 constuctors are protected.
				@return Static TDETrader instance

		@short    This is a static pointer to a TDETrader instance.
	*/
	public static native TDETrader self();
	/**
			     		@short
	*/
	public TDETrader() {
		super((Class) null);
		newTDETrader();
	}
	private native void newTDETrader();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
