//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQRect;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPainter;
import org.trinitydesktop.qt.TQFontMetrics;

/**

 Word-wrap algorithm that takes into account beautifulness ;)
 That means:

	<li>
	not letting a letter alone on the last line,
	</li>

	<li>
	breaking at punctuation signs (not only at spaces)
	</li>

	<li>
	improved handling of (), [] and {}
	</li>

	<li>
	improved handling of '/' (e.g. for paths)
	</li>
	 Usage: call the static method, formatText, with the text to
 wrap and the constraining rectangle etc., it will return an instance of KWordWrap
 containing internal data, result of the word-wrapping.
 From that instance you can retrieve the boundingRect, and invoke drawing.
 This design allows to call the word-wrap algorithm only when the text changes
 and not every time we want to know the bounding rect or draw the text.
		@author David Faure <faure@kde.org>

		@short    Word-wrap algorithm that takes into account beautifulness ;)

*/
public class KWordWrap implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KWordWrap(Class dummy){}

	/**
		 Use this flag in drawText() if you want to fade out the text if it does
		 not fit into the constraining rectangle.
				@short    Use this flag in drawText() if you want to fade out the text if it does  not fit into the constraining rectangle.
	*/
	public static final int FadeOut = 0x10000000;
	public static final int Truncate = 0x20000000;

	/**
				@return the bounding rect, calculated by formatText. The width is the
         width of the widest text line, and never wider than
         the rectangle given to formatText. The height is the
         text block. X and Y are always 0.

		@short
	*/
	public native TQRect boundingRect();
	/**
				@return the original string, with '\n' inserted where
 the text is broken by the wordwrap algorithm.

		@short
	*/
	public native String wrappedString();
	/**
				@return the original string, truncated to the first line.
 If <code>dots</code> was set, '...' is appended in case the string was truncated.
 Bug: Note that the '...' come out of the bounding rect.

		@short
	*/
	public native String truncatedString(boolean dots);
	public native String truncatedString();
	/**
		 Draw the text that has been previously wrapped, at position x,y.
		 Flags are for alignment, e.g. Qt.AlignHCenter. Default is
		 Qt.AlignAuto.
			@param painter the TQPainter to use.
			@param x the horizontal position of the text
			@param y the vertical position of the text
			@param flags the ORed text alignment flags from the Qt namespace,
		              ORed with FadeOut if you want the text to fade out if it
		              does not fit (the <code>painter</code>'s background must be set
		              accordingly)
		     		@short    Draw the text that has been previously wrapped, at position x,y.
	*/
	public native void drawText(TQPainter painter, int x, int y, int flags);
	public native void drawText(TQPainter painter, int x, int y);
	/**
		 Main method for wrapping text.
			@param fm Font metrics, for the chosen font. Better cache it, creating a TQFontMetrics is expensive.
			@param r Constraining rectangle. Only the width and height matter. With
		          negative height the complete text will be rendered
			@param flags currently unused
			@param str The text to be wrapped.
			@param len Length of text to wrap (default is -1 for all).
				@return a KWordWrap instance. The caller is responsible for storing and deleting the result.

		@short    Main method for wrapping text.
	*/
	public static native KWordWrap formatText(TQFontMetrics fm, TQRect r, int flags, String str, int len);
	public static native KWordWrap formatText(TQFontMetrics fm, TQRect r, int flags, String str);
	/**
		 Draws the string <code>t</code> at the given coordinates, if it does not
		 <code>fit</code> into <code>maxW</code> the text will be faded out.
			@param p the painter to use. Must have set the pen for the text
		        color and the background for the color to fade out
			@param x the horizontal position of the text
			@param y the vertical position of the text
			@param maxW the maximum width of the text (including the fade-out
		             effect)
			@param t the text to draw
				@short    Draws the string <code>t</code> at the given coordinates, if it does not  <code>fit</code> into <code>maxW</code> the text will be faded out.
	*/
	public static native void drawFadeoutText(TQPainter p, int x, int y, int maxW, String t);
	/**
		 Draws the string <code>t</code> at the given coordinates, if it does not
		 <code>fit</code> into <code>maxW</code> the text will be truncated.
			@param p the painter to use
			@param x the horizontal position of the text
			@param y the vertical position of the text
			@param maxW the maximum width of the text (including the '...')
			@param t the text to draw
				@short    Draws the string <code>t</code> at the given coordinates, if it does not  <code>fit</code> into <code>maxW</code> the text will be truncated.
	*/
	public static native void drawTruncateText(TQPainter p, int x, int y, int maxW, String t);
}
