//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQDataStream;
import org.trinitydesktop.qt.TQPixmap;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQVariant;

/**

 Represent a mime type, like "text/plain", and the data that is associated
 with it.
 The starting point you need is often the static methods.
 KMimeType inherits KServiceType because "text/plain" can be used to find
 services (apps and components) "which can open text/plain".
		@short    Represent a mime type, like "text/plain", and the data that is associated  with it.
		@see KServiceType

*/
public class KMimeType extends KServiceType  {
	protected KMimeType(Class dummy){super((Class) null);}
	/**
		 Constructor.
			 You may pass in arguments to create a mimetype with
		 specific properties.
			@param _fullpath the path to the configuration file (.desktop)
			@param _type the mime type itself
			@param _icon the name of the icon that represens the mime type
			@param _comment a comment describing the mime type
			@param _patterns a list of file globs that describes the names (or
		                  extensions) of the files with this mime type
		   		@short    Constructor.
	*/
	public KMimeType(String _fullpath, String _type, String _icon, String _comment, String[] _patterns) {
		super((Class) null);
		newKMimeType(_fullpath,_type,_icon,_comment,_patterns);
	}
	private native void newKMimeType(String _fullpath, String _type, String _icon, String _comment, String[] _patterns);
	/**
		 Construct a mimetype and take all information from a config file.
			@param _fullpath the path to the configuration file (.desktop)
		   		@short    Construct a mimetype and take all information from a config file.
	*/
	public KMimeType(String _fullpath) {
		super((Class) null);
		newKMimeType(_fullpath);
	}
	private native void newKMimeType(String _fullpath);
	/**
		 Construct a mimetype and take all information from a desktop file.
			@param config the desktop configuration file that describes the mime type
		   		@short    Construct a mimetype and take all information from a desktop file.
	*/
	public KMimeType(TDEDesktopFile config) {
		super((Class) null);
		newKMimeType(config);
	}
	private native void newKMimeType(TDEDesktopFile config);
	/**
			 The stream must already be positionned at the correct offset
		   		@short
	*/
	public KMimeType(TQDataStream _str, int offset) {
		super((Class) null);
		newKMimeType(_str,offset);
	}
	private native void newKMimeType(TQDataStream _str, int offset);
	/**
		 Return the filename of the icon associated with the mimetype.
			 The arguments are unused, but provided so that KMimeType-derived classes
		 can use them (e.g. KFolderType uses the URL to return one out of 2 icons)
				@return The path to the icon associated with this MIME type.

		@short    Return the filename of the icon associated with the mimetype.
	*/
	public native String icon(String arg1, boolean arg2);
	/**
		 Return the filename of the icon associated with the mimetype.
			 The arguments are unused, but provided so that KMimeType-derived classes
		 can use them (e.g. KFolderType uses the URL to return one out of 2 icons)
				@return The path to the icon associated with this MIME type.

		@short    Return the filename of the icon associated with the mimetype.
	*/
	public native String icon(KURL arg1, boolean arg2);
	/**
		 Use this function only if you don't have a special URL
		 for which you search a pixmap.
			 This function is useful to find
		 out, which icon is usually chosen for a certain mime type. Since
		 no URL is passed, it is impossible to obey icon hints in desktop
		 entries for example.
			@param group The icon group where the icon is going to be used.
			@param force_size Override globallly configured icon size.
		        Use 0 for the default size
			@param state The icon state, one of: <code>TDEIcon</code>.DefaultState,
		         <code>TDEIcon</code>.ActiveState or <code>TDEIcon</code>.DisabledState.
			@param path Output parameter to get the full path. Seldom needed.
		              Ignored if 0
				@return the pixmap of the mime type, can be a default icon if not found

		@short    Use this function only if you don't have a special URL  for which you search a pixmap.
	*/
	public native TQPixmap pixmap(int group, int force_size, int state, StringBuffer path);
	public native TQPixmap pixmap(int group, int force_size, int state);
	public native TQPixmap pixmap(int group, int force_size);
	public native TQPixmap pixmap(int group);
	/**
		 Find the pixmap for a given file of this mimetype.
			 Convenience method that uses icon(), but also locates and
		 load the pixmap.
			@param _url URL for the file.
			@param _group The icon group where the icon is going to be used.
			@param _force_size Override globallly configured icon size.
		        Use 0 for the default size
			@param _state The icon state, one of: TDEIcon.DefaultState,
		 TDEIcon.ActiveState or TDEIcon.DisabledState.
			@param _path Output parameter to get the full path. Seldom needed.
		              Ignored if 0
				@return the pixmap of the URL, can be a default icon if not found

		@short    Find the pixmap for a given file of this mimetype.
	*/
	public native TQPixmap pixmap(KURL _url, int _group, int _force_size, int _state, StringBuffer _path);
	public native TQPixmap pixmap(KURL _url, int _group, int _force_size, int _state);
	public native TQPixmap pixmap(KURL _url, int _group, int _force_size);
	public native TQPixmap pixmap(KURL _url, int _group);
	/**
		 Returns the descriptive comment associated with the MIME type.
				@return the descriptive comment associated with the MIME type

		@short    Returns the descriptive comment associated with the MIME type.
	*/
	public native String comment();
	/**
		 Returns the descriptive comment associated with the MIME type.
		 The arguments are unused, but provided so that KMimeType derived classes
		 can use them.
				@return The descriptive comment associated with the MIME type, if any.

		@short    Returns the descriptive comment associated with the MIME type.
	*/
	public native String comment(String arg1, boolean arg2);
	/**
		 Returns the descriptive comment associated with the MIME type.
		 The arguments are unused, but provided so that KMimeType derived classes
		 can use them.
				@return The descriptive comment associated with the MIME type, if any.

		@short    Returns the descriptive comment associated with the MIME type.
	*/
	public native String comment(KURL arg1, boolean arg2);
	/**
		 Retrieve the list of patterns associated with the MIME Type.
				@return a list of file globs that describe the file names
         (or, usually, the extensions) of files with this mime type

		@short    Retrieve the list of patterns associated with the MIME Type.
	*/
	public native ArrayList patterns();
	/**
		 Load the mimetype from a stream.
			@param qs the stream to load from
		   		@short    Load the mimetype from a stream.
	*/
	public native void load(TQDataStream qs);
	/**
		 Save the mimetype to a stream.
			@param qs the stream to save to
		   		@short    Save the mimetype to a stream.
	*/
	public native void save(TQDataStream qs);
	/**
		 Returns the property with the given <code>_name.</code>
			@param _name the name of the property
				@return the value of the property

		@short    Returns the property with the given <code>_name.</code>
		@see #propertyNames
	*/
	public native TQVariant property(String _name);
	/**
		 Retrieves a list of all properties associated with this
		 KMimeType.
				@return a list of all property names

		@short    Retrieves a list of all properties associated with this  KMimeType.
		@see #property
	*/
	public native ArrayList propertyNames();
	/**
		 If this mimetype inherits from ("is also") another mimetype,
		 return the name of the parent.
			 For instance a text/x-log is a special kind of text/plain,
		 so the definition of text/x-log can say "X-TDE-IsAlso=text/plain".
		 Or an smb-workgroup is a special kind of inode/directory, etc.
		 This mechanism can also be used to rename mimetypes and preserve compat.
			 Note that this notion doesn't map to the servicetype inheritance mechanism,
		 since an application that handles the specific type doesn't necessarily handle
		 the base type. The opposite is true though.
				@return the parent mime type, or null if not set

		@short    If this mimetype inherits from ("is also") another mimetype,  return the name of the parent.
	*/
	public native String parentMimeType();
	/**
		 Do not use name()=="somename" anymore, to check for a given mimetype.
		 For mimetype inheritance to work, use is("somename") instead.
		 Warning, do not use inherits(), that's the servicetype inheritance concept!
				@short    Do not use name()=="somename" anymore, to check for a given mimetype.
	*/
	public native boolean is(String mimeTypeName);
	/**
		 Convenience method to find the pixmap for a URL.
			 Call this one when you don't know the mimetype.
			@param _url URL for the file.
			@param _mode the mode of the file. The mode may modify the icon
		              with overlays that show special properties of the
		              icon. Use 0 for default
			@param _group The icon group where the icon is going to be used.
			@param _force_size Override globally configured icon size.
		        Use 0 for the default size
			@param _state The icon state, one of: TDEIcon.DefaultState,
		 TDEIcon.ActiveState or TDEIcon.DisabledState.
			@param _path Output parameter to get the full path. Seldom needed.
		              Ignored if 0
				@return the pixmap of the URL, can be a default icon if not found

		@short    Convenience method to find the pixmap for a URL.
	*/
	public static native TQPixmap pixmapForURL(KURL _url, long _mode, int _group, int _force_size, int _state, StringBuffer _path);
	public static native TQPixmap pixmapForURL(KURL _url, long _mode, int _group, int _force_size, int _state);
	public static native TQPixmap pixmapForURL(KURL _url, long _mode, int _group, int _force_size);
	public static native TQPixmap pixmapForURL(KURL _url, long _mode, int _group);
	public static native TQPixmap pixmapForURL(KURL _url, long _mode);
	public static native TQPixmap pixmapForURL(KURL _url);
	/**
		 The same functionality as pixmapForURL(), but this method returns the name
		 of the icon to load. You'll have to use TDEIconLoader to load the pixmap for it.
		 The advantage of this method is that you can store the result, and then use it
		 later on for any kind of size.
			@param _url URL for the file
			@param _mode the mode of the file. The mode may modify the icon
		              with overlays that show special properties of the
		              icon. Use 0 for default
				@return the name of the icon. The name of a default icon if there is no icon
         for the mime type

		@short    The same functionality as pixmapForURL(), but this method returns the name  of the icon to load.
	*/
	public static native String iconForURL(KURL _url, long _mode);
	public static native String iconForURL(KURL _url);
	/**
		 Return the "favicon" (see http://www.favicon.com) for the given <code>url</code>,
		 if available. Does NOT attempt to download the favicon, it only returns
		 one that is already available.
			 If unavailable, returns null.
			@param url the URL of the favicon
				@return the name of the favicon, or null

		@short    Return the "favicon" (see http://www.
	*/
	public static native String favIconForURL(KURL url);
	/**
		 Retrieve a pointer to the mime type <code>_name</code> or a pointer to the default
		         mime type "application/octet-stream".
			 null is <b>never</b> returned.
			 <b>Very</b> <b>important</b>: Don't store the result in a KMimeType !
			@param _name the name of the mime type
				@return the pointer to the KMimeType with the given <code>_name</code>, or
         a pointer to the application/octet-stream KMimeType if
         not found

		@short    Retrieve a pointer to the mime type <code>_name</code> or a pointer to the default          mime type "application/octet-stream".
		@see KServiceType#serviceType
	*/
	// KMimeType::Ptr mimeType(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Finds a KMimeType with the given <code>_url.</code>
		 This function looks at mode_t first.
		 If that does not help it
		 looks at the extension.  This is fine for FTP, FILE, TAR and
		 friends, but is not for HTTP ( cgi scripts! ). You should use
		 KRun instead, but this function returns immediately while
		 KRun is async. If no extension matches, then
		 the file will be examined if the URL a local file or
		 "application/octet-stream" is returned otherwise.
			@param _url Is the right most URL with a filesystem protocol. It
		        is up to you to find out about that if you have a nested
		        URL.  For example
		        "http://localhost/mist.gz#gzip:/decompress" would have to
		        pass the "http://..." URL part, while
		        "file:/tmp/x.tar#tar:/src/test.gz#gzip:/decompress" would
		        have to pass the "tar:/..." part of the URL, since gzip is
		        a filter protocol and not a filesystem protocol.
			@param _mode the mode of the file (used, for example, to identify
		              executables)
			@param _is_local_file true if the file is local
			@param _fast_mode If set to true no disk access is allowed to
		        find out the mimetype. The result may be suboptimal, but
		        it is <b>fast</b>.
				@return A pointer to the matching mimetype. 0L is never returned.
 @em Very @em Important: Don't store the result in a KMimeType* !

		@short    Finds a KMimeType with the given <code>_url.</code>
	*/
	// KMimeType::Ptr findByURL(const KURL& arg1,mode_t arg2,bool arg3,bool arg4); >>>> NOT CONVERTED
	// KMimeType::Ptr findByURL(const KURL& arg1,mode_t arg2,bool arg3); >>>> NOT CONVERTED
	// KMimeType::Ptr findByURL(const KURL& arg1,mode_t arg2); >>>> NOT CONVERTED
	// KMimeType::Ptr findByURL(const KURL& arg1); >>>> NOT CONVERTED
	// KMimeType::Ptr findByURL(const KURL& arg1,mode_t arg2,bool arg3,bool arg4,bool* arg5); >>>> NOT CONVERTED
	/**
		 Finds a KMimeType with the given <code>_url.</code>
		 This function looks at mode_t first.
		 If that does not help it
		 looks at the extension.  This is fine for FTP, FILE, TAR and
		 friends, but is not for HTTP ( cgi scripts! ). You should use
		 KRun instead, but this function returns immediately while
		 KRun is async. If no extension matches, then
		 the file will be examined if the URL a local file or
		 "application/octet-stream" is returned otherwise.
			 Equivalent to
		 <pre>
		 KURL u;
		 u.setPath(path);
		 return findByURL( u, mode, true, fast_mode );
		 </pre>
			@param path the path to the file
			@param mode the mode of the file (used, for example, to identify
		              executables)
			@param fast_mode If set to true no disk access is allowed to
		        find out the mimetype. The result may be suboptimal, but
		        it is <b>fast</b>.
				@return A pointer to the matching mimetype. 0L is never returned.

		@short    Finds a KMimeType with the given <code>_url.</code>
	*/
	// KMimeType::Ptr findByPath(const TQString& arg1,mode_t arg2,bool arg3); >>>> NOT CONVERTED
	// KMimeType::Ptr findByPath(const TQString& arg1,mode_t arg2); >>>> NOT CONVERTED
	// KMimeType::Ptr findByPath(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Tries to find out the MIME type of a data chunk by looking for
		 certain magic numbers and characteristic strings in it.
			@param data the data to examine
			@param accuracy If not a null pointer, accuracy is set to the
		          accuracy of the match (which is in the range 0..100)
				@return a pointer to the KMimeType. application/octet-stream's KMimeType of the
         type can not be found this way.

		@short    Tries to find out the MIME type of a data chunk by looking for  certain magic numbers and characteristic strings in it.
	*/
	// KMimeType::Ptr findByContent(const TQByteArray& arg1,int* arg2); >>>> NOT CONVERTED
	// KMimeType::Ptr findByContent(const TQByteArray& arg1); >>>> NOT CONVERTED
	/**
		 Tries to find out the MIME type of a file by looking for
		 certain magic numbers and characteristic strings in it.
		 This function is similar to the previous one. Note that the
		 file name is not used for determining the file type, it is just
		 used for loading the file's contents.
			@param fileName the path to the file
			@param accuracy If not a null pointer, accuracy is set to the
		          accuracy of the match (which is in the range 0..100)
				@return a pointer to the KMimeType. application/octet-stream's KMimeType of the
         type can not be found this way.

		@short    Tries to find out the MIME type of a file by looking for  certain magic numbers and characteristic strings in it.
	*/
	// KMimeType::Ptr findByFileContent(const TQString& arg1,int* arg2); >>>> NOT CONVERTED
	// KMimeType::Ptr findByFileContent(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Returns whether a file has an internal format that is human readable,
		 or that would be human readable after decompression.
				@short    Returns whether a file has an internal format that is human readable,  or that would be human readable after decompression.
	*/
	// KMimeType::Format findFormatByFileContent(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Get all the mimetypes.
			 Useful for showing the list of
		 available mimetypes.
		 More memory consuming than the ones above, don't use unless
		 really necessary.
				@return the list of all existing KMimeTypes

		@short    Get all the mimetypes.
	*/
	// KMimeType::List allMimeTypes(); >>>> NOT CONVERTED
	/**
		 Returns the name of the default mimetype.
		 Always application/octet-stream, but this method exists
		 for performance purposes.
				@return the name of the default mime type, always
         "application/octet-stream"

		@short    Returns the name of the default mimetype.
	*/
	public static native String defaultMimeType();
	/**
		 Returns the default mimetype.
		 Always application/octet-stream.
		 This can be used to check the result of mimeType(name).
				@return the "application/octet-stream" mimetype pointer.

		@short    Returns the default mimetype.
	*/
	// KMimeType::Ptr defaultMimeTypePtr(); >>>> NOT CONVERTED
	/**
			 Determines the mimetype of file based on it's name and returns the
		 matching pattern if any.
		   		@short
	*/
	// KMimeType::Ptr diagnoseFileName(const TQString& arg1,TQString& arg2); >>>> NOT CONVERTED
	protected native void loadInternal(TQDataStream arg1);
	protected native void init(TDEDesktopFile arg1);
	protected native int patternsAccuracy();
	/**
		 Signal a missing mime type.
			@param _type the missinf mime type
		   		@short    Signal a missing mime type.
	*/
	protected static native void errorMissingMimeType(String _type);
	/**
		 This function makes sure that the default mime type exists.
		   		@short    This function makes sure that the default mime type exists.
	*/
	protected static native void buildDefaultType();
	/**
		 This function makes sure that vital mime types are installed.
		   		@short    This function makes sure that vital mime types are installed.
	*/
	protected static native void checkEssentialMimeTypes();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
