import org.trinitydesktop.qt.*;

public class KillerFilter extends TQObject {

	public boolean eventFilter( TQObject object, TQEvent event) {
		if (event.type() == TQEvent.MouseButtonPress) {
			if ( ((TQMouseEvent)event).button() == RightButton ) {
				((TQWidget) object).close();
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
		
	public static void main(String[] args)
	{
		TQApplication a = new TQApplication(args);
		
		TQWidget toplevel = new TQWidget();
		toplevel.resize( 230, 130 );
		
		TQObject killerFilter = new KillerFilter();
		
		TQPushButton pb = new TQPushButton(toplevel);
		pb.setGeometry(10, 10, 100, 50 );
		pb.setText( "pushbutton" );
		pb.installEventFilter( killerFilter );
		
		TQLineEdit le = new TQLineEdit( toplevel );
		le.setGeometry( 10, 70, 100, 50 );
		le.setText( "Line edit" );
		le.installEventFilter( killerFilter );
		
		TQCheckBox cb = new TQCheckBox( toplevel );
		cb.setGeometry( 120, 10, 100, 50 );
		cb.setText( "Check-box" );
		cb.installEventFilter( killerFilter );
		
		TQRadioButton rb = new TQRadioButton( toplevel );
		rb.setGeometry( 120, 70, 100, 50 );
		rb.setText( "Radio button" );
		rb.installEventFilter( killerFilter );
		
		a.setMainWidget(toplevel);
		toplevel.show();
		a.exec();
		return;
	}
	
	static {
                qtjava.initialize();
	}
}
